package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{VpcId, CarrierGatewayId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CarrierGateway(
    carrierGatewayId: Optional[CarrierGatewayId] = Optional.Absent,
    vpcId: Optional[VpcId] = Optional.Absent,
    state: Optional[zio.aws.ec2.model.CarrierGatewayState] = Optional.Absent,
    ownerId: Optional[String] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CarrierGateway = {
    import CarrierGateway.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CarrierGateway
      .builder()
      .optionallyWith(
        carrierGatewayId.map(value =>
          CarrierGatewayId.unwrap(value): java.lang.String
        )
      )(_.carrierGatewayId)
      .optionallyWith(
        vpcId.map(value => VpcId.unwrap(value): java.lang.String)
      )(_.vpcId)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CarrierGateway.ReadOnly =
    zio.aws.ec2.model.CarrierGateway.wrap(buildAwsValue())
}
object CarrierGateway {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CarrierGateway
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CarrierGateway =
      zio.aws.ec2.model.CarrierGateway(
        carrierGatewayId.map(value => value),
        vpcId.map(value => value),
        state.map(value => value),
        ownerId.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def carrierGatewayId: Optional[CarrierGatewayId]
    def vpcId: Optional[VpcId]
    def state: Optional[zio.aws.ec2.model.CarrierGatewayState]
    def ownerId: Optional[String]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getCarrierGatewayId: ZIO[Any, AwsError, CarrierGatewayId] =
      AwsError.unwrapOptionField("carrierGatewayId", carrierGatewayId)
    def getVpcId: ZIO[Any, AwsError, VpcId] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getState: ZIO[Any, AwsError, zio.aws.ec2.model.CarrierGatewayState] =
      AwsError.unwrapOptionField("state", state)
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CarrierGateway
  ) extends zio.aws.ec2.model.CarrierGateway.ReadOnly {
    override val carrierGatewayId: Optional[CarrierGatewayId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.carrierGatewayId())
        .map(value => zio.aws.ec2.model.primitives.CarrierGatewayId(value))
    override val vpcId: Optional[VpcId] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => zio.aws.ec2.model.primitives.VpcId(value))
    override val state: Optional[zio.aws.ec2.model.CarrierGatewayState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.ec2.model.CarrierGatewayState.wrap(value))
    override val ownerId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerId())
      .map(value => value: String)
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CarrierGateway
  ): zio.aws.ec2.model.CarrierGateway.ReadOnly = new Wrapper(impl)
}
