package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AvailabilityZone(
    state: Optional[zio.aws.ec2.model.AvailabilityZoneState] = Optional.Absent,
    optInStatus: Optional[zio.aws.ec2.model.AvailabilityZoneOptInStatus] =
      Optional.Absent,
    messages: Optional[Iterable[zio.aws.ec2.model.AvailabilityZoneMessage]] =
      Optional.Absent,
    regionName: Optional[String] = Optional.Absent,
    zoneName: Optional[String] = Optional.Absent,
    zoneId: Optional[String] = Optional.Absent,
    groupName: Optional[String] = Optional.Absent,
    networkBorderGroup: Optional[String] = Optional.Absent,
    zoneType: Optional[String] = Optional.Absent,
    parentZoneName: Optional[String] = Optional.Absent,
    parentZoneId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AvailabilityZone = {
    import AvailabilityZone.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AvailabilityZone
      .builder()
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(optInStatus.map(value => value.unwrap))(_.optInStatus)
      .optionallyWith(
        messages.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.messages)
      .optionallyWith(regionName.map(value => value: java.lang.String))(
        _.regionName
      )
      .optionallyWith(zoneName.map(value => value: java.lang.String))(
        _.zoneName
      )
      .optionallyWith(zoneId.map(value => value: java.lang.String))(_.zoneId)
      .optionallyWith(groupName.map(value => value: java.lang.String))(
        _.groupName
      )
      .optionallyWith(networkBorderGroup.map(value => value: java.lang.String))(
        _.networkBorderGroup
      )
      .optionallyWith(zoneType.map(value => value: java.lang.String))(
        _.zoneType
      )
      .optionallyWith(parentZoneName.map(value => value: java.lang.String))(
        _.parentZoneName
      )
      .optionallyWith(parentZoneId.map(value => value: java.lang.String))(
        _.parentZoneId
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AvailabilityZone.ReadOnly =
    zio.aws.ec2.model.AvailabilityZone.wrap(buildAwsValue())
}
object AvailabilityZone {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AvailabilityZone
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AvailabilityZone =
      zio.aws.ec2.model.AvailabilityZone(
        state.map(value => value),
        optInStatus.map(value => value),
        messages.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        regionName.map(value => value),
        zoneName.map(value => value),
        zoneId.map(value => value),
        groupName.map(value => value),
        networkBorderGroup.map(value => value),
        zoneType.map(value => value),
        parentZoneName.map(value => value),
        parentZoneId.map(value => value)
      )
    def state: Optional[zio.aws.ec2.model.AvailabilityZoneState]
    def optInStatus: Optional[zio.aws.ec2.model.AvailabilityZoneOptInStatus]
    def messages
        : Optional[List[zio.aws.ec2.model.AvailabilityZoneMessage.ReadOnly]]
    def regionName: Optional[String]
    def zoneName: Optional[String]
    def zoneId: Optional[String]
    def groupName: Optional[String]
    def networkBorderGroup: Optional[String]
    def zoneType: Optional[String]
    def parentZoneName: Optional[String]
    def parentZoneId: Optional[String]
    def getState: ZIO[Any, AwsError, zio.aws.ec2.model.AvailabilityZoneState] =
      AwsError.unwrapOptionField("state", state)
    def getOptInStatus
        : ZIO[Any, AwsError, zio.aws.ec2.model.AvailabilityZoneOptInStatus] =
      AwsError.unwrapOptionField("optInStatus", optInStatus)
    def getMessages: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.AvailabilityZoneMessage.ReadOnly
    ]] = AwsError.unwrapOptionField("messages", messages)
    def getRegionName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("regionName", regionName)
    def getZoneName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("zoneName", zoneName)
    def getZoneId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("zoneId", zoneId)
    def getGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getNetworkBorderGroup: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("networkBorderGroup", networkBorderGroup)
    def getZoneType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("zoneType", zoneType)
    def getParentZoneName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parentZoneName", parentZoneName)
    def getParentZoneId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parentZoneId", parentZoneId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AvailabilityZone
  ) extends zio.aws.ec2.model.AvailabilityZone.ReadOnly {
    override val state: Optional[zio.aws.ec2.model.AvailabilityZoneState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.ec2.model.AvailabilityZoneState.wrap(value))
    override val optInStatus
        : Optional[zio.aws.ec2.model.AvailabilityZoneOptInStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.optInStatus())
        .map(value => zio.aws.ec2.model.AvailabilityZoneOptInStatus.wrap(value))
    override val messages
        : Optional[List[zio.aws.ec2.model.AvailabilityZoneMessage.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.messages())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.AvailabilityZoneMessage.wrap(item)
          }.toList
        )
    override val regionName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.regionName())
      .map(value => value: String)
    override val zoneName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.zoneName())
      .map(value => value: String)
    override val zoneId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.zoneId())
      .map(value => value: String)
    override val groupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.groupName())
      .map(value => value: String)
    override val networkBorderGroup: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.networkBorderGroup())
      .map(value => value: String)
    override val zoneType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.zoneType())
      .map(value => value: String)
    override val parentZoneName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.parentZoneName())
      .map(value => value: String)
    override val parentZoneId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.parentZoneId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AvailabilityZone
  ): zio.aws.ec2.model.AvailabilityZone.ReadOnly = new Wrapper(impl)
}
