package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.MillisecondDateTime
import scala.jdk.CollectionConverters._
final case class VpcEndpointConnection(
    serviceId: Optional[String] = Optional.Absent,
    vpcEndpointId: Optional[String] = Optional.Absent,
    vpcEndpointOwner: Optional[String] = Optional.Absent,
    vpcEndpointState: Optional[zio.aws.ec2.model.State] = Optional.Absent,
    creationTimestamp: Optional[MillisecondDateTime] = Optional.Absent,
    dnsEntries: Optional[Iterable[zio.aws.ec2.model.DnsEntry]] =
      Optional.Absent,
    networkLoadBalancerArns: Optional[Iterable[String]] = Optional.Absent,
    gatewayLoadBalancerArns: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.VpcEndpointConnection = {
    import VpcEndpointConnection.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.VpcEndpointConnection
      .builder()
      .optionallyWith(serviceId.map(value => value: java.lang.String))(
        _.serviceId
      )
      .optionallyWith(vpcEndpointId.map(value => value: java.lang.String))(
        _.vpcEndpointId
      )
      .optionallyWith(vpcEndpointOwner.map(value => value: java.lang.String))(
        _.vpcEndpointOwner
      )
      .optionallyWith(vpcEndpointState.map(value => value.unwrap))(
        _.vpcEndpointState
      )
      .optionallyWith(
        creationTimestamp.map(value =>
          MillisecondDateTime.unwrap(value): Instant
        )
      )(_.creationTimestamp)
      .optionallyWith(
        dnsEntries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dnsEntries)
      .optionallyWith(
        networkLoadBalancerArns.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.networkLoadBalancerArns)
      .optionallyWith(
        gatewayLoadBalancerArns.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.gatewayLoadBalancerArns)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.VpcEndpointConnection.ReadOnly =
    zio.aws.ec2.model.VpcEndpointConnection.wrap(buildAwsValue())
}
object VpcEndpointConnection {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.VpcEndpointConnection
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.VpcEndpointConnection =
      zio.aws.ec2.model.VpcEndpointConnection(
        serviceId.map(value => value),
        vpcEndpointId.map(value => value),
        vpcEndpointOwner.map(value => value),
        vpcEndpointState.map(value => value),
        creationTimestamp.map(value => value),
        dnsEntries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        networkLoadBalancerArns.map(value => value),
        gatewayLoadBalancerArns.map(value => value)
      )
    def serviceId: Optional[String]
    def vpcEndpointId: Optional[String]
    def vpcEndpointOwner: Optional[String]
    def vpcEndpointState: Optional[zio.aws.ec2.model.State]
    def creationTimestamp: Optional[MillisecondDateTime]
    def dnsEntries: Optional[List[zio.aws.ec2.model.DnsEntry.ReadOnly]]
    def networkLoadBalancerArns: Optional[List[String]]
    def gatewayLoadBalancerArns: Optional[List[String]]
    def getServiceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceId", serviceId)
    def getVpcEndpointId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcEndpointId", vpcEndpointId)
    def getVpcEndpointOwner: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcEndpointOwner", vpcEndpointOwner)
    def getVpcEndpointState: ZIO[Any, AwsError, zio.aws.ec2.model.State] =
      AwsError.unwrapOptionField("vpcEndpointState", vpcEndpointState)
    def getCreationTimestamp: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("creationTimestamp", creationTimestamp)
    def getDnsEntries
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.DnsEntry.ReadOnly]] =
      AwsError.unwrapOptionField("dnsEntries", dnsEntries)
    def getNetworkLoadBalancerArns: ZIO[Any, AwsError, List[String]] = AwsError
      .unwrapOptionField("networkLoadBalancerArns", networkLoadBalancerArns)
    def getGatewayLoadBalancerArns: ZIO[Any, AwsError, List[String]] = AwsError
      .unwrapOptionField("gatewayLoadBalancerArns", gatewayLoadBalancerArns)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.VpcEndpointConnection
  ) extends zio.aws.ec2.model.VpcEndpointConnection.ReadOnly {
    override val serviceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceId())
      .map(value => value: String)
    override val vpcEndpointId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcEndpointId())
      .map(value => value: String)
    override val vpcEndpointOwner: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcEndpointOwner())
      .map(value => value: String)
    override val vpcEndpointState: Optional[zio.aws.ec2.model.State] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcEndpointState())
        .map(value => zio.aws.ec2.model.State.wrap(value))
    override val creationTimestamp: Optional[MillisecondDateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creationTimestamp())
        .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val dnsEntries
        : Optional[List[zio.aws.ec2.model.DnsEntry.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dnsEntries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.DnsEntry.wrap(item)
          }.toList
        )
    override val networkLoadBalancerArns: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkLoadBalancerArns())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val gatewayLoadBalancerArns: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gatewayLoadBalancerArns())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.VpcEndpointConnection
  ): zio.aws.ec2.model.VpcEndpointConnection.ReadOnly = new Wrapper(impl)
}
