package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.MillisecondDateTime
import scala.jdk.CollectionConverters._
final case class VolumeStatusEvent(
    description: Optional[String] = Optional.Absent,
    eventId: Optional[String] = Optional.Absent,
    eventType: Optional[String] = Optional.Absent,
    notAfter: Optional[MillisecondDateTime] = Optional.Absent,
    notBefore: Optional[MillisecondDateTime] = Optional.Absent,
    instanceId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.VolumeStatusEvent = {
    import VolumeStatusEvent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.VolumeStatusEvent
      .builder()
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(eventId.map(value => value: java.lang.String))(_.eventId)
      .optionallyWith(eventType.map(value => value: java.lang.String))(
        _.eventType
      )
      .optionallyWith(
        notAfter.map(value => MillisecondDateTime.unwrap(value): Instant)
      )(_.notAfter)
      .optionallyWith(
        notBefore.map(value => MillisecondDateTime.unwrap(value): Instant)
      )(_.notBefore)
      .optionallyWith(instanceId.map(value => value: java.lang.String))(
        _.instanceId
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.VolumeStatusEvent.ReadOnly =
    zio.aws.ec2.model.VolumeStatusEvent.wrap(buildAwsValue())
}
object VolumeStatusEvent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.VolumeStatusEvent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.VolumeStatusEvent =
      zio.aws.ec2.model.VolumeStatusEvent(
        description.map(value => value),
        eventId.map(value => value),
        eventType.map(value => value),
        notAfter.map(value => value),
        notBefore.map(value => value),
        instanceId.map(value => value)
      )
    def description: Optional[String]
    def eventId: Optional[String]
    def eventType: Optional[String]
    def notAfter: Optional[MillisecondDateTime]
    def notBefore: Optional[MillisecondDateTime]
    def instanceId: Optional[String]
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getEventId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eventId", eventId)
    def getEventType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eventType", eventType)
    def getNotAfter: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("notAfter", notAfter)
    def getNotBefore: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("notBefore", notBefore)
    def getInstanceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceId", instanceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.VolumeStatusEvent
  ) extends zio.aws.ec2.model.VolumeStatusEvent.ReadOnly {
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val eventId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.eventId())
      .map(value => value: String)
    override val eventType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.eventType())
      .map(value => value: String)
    override val notAfter: Optional[MillisecondDateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.notAfter())
      .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val notBefore: Optional[MillisecondDateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notBefore())
        .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val instanceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.VolumeStatusEvent
  ): zio.aws.ec2.model.VolumeStatusEvent.ReadOnly = new Wrapper(impl)
}
