package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait TransitGatewayPrefixListReferenceState {
  def unwrap: software.amazon.awssdk.services.ec2.model.TransitGatewayPrefixListReferenceState
}
object TransitGatewayPrefixListReferenceState {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.TransitGatewayPrefixListReferenceState
  ): zio.aws.ec2.model.TransitGatewayPrefixListReferenceState = value match {
    case software.amazon.awssdk.services.ec2.model.TransitGatewayPrefixListReferenceState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.TransitGatewayPrefixListReferenceState.PENDING =>
      val r = pending
      r
    case software.amazon.awssdk.services.ec2.model.TransitGatewayPrefixListReferenceState.AVAILABLE =>
      val r = available
      r
    case software.amazon.awssdk.services.ec2.model.TransitGatewayPrefixListReferenceState.MODIFYING =>
      val r = modifying
      r
    case software.amazon.awssdk.services.ec2.model.TransitGatewayPrefixListReferenceState.DELETING =>
      val r = deleting
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.TransitGatewayPrefixListReferenceState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TransitGatewayPrefixListReferenceState =
      software.amazon.awssdk.services.ec2.model.TransitGatewayPrefixListReferenceState.UNKNOWN_TO_SDK_VERSION
  }
  case object pending
      extends zio.aws.ec2.model.TransitGatewayPrefixListReferenceState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TransitGatewayPrefixListReferenceState =
      software.amazon.awssdk.services.ec2.model.TransitGatewayPrefixListReferenceState.PENDING
  }
  case object available
      extends zio.aws.ec2.model.TransitGatewayPrefixListReferenceState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TransitGatewayPrefixListReferenceState =
      software.amazon.awssdk.services.ec2.model.TransitGatewayPrefixListReferenceState.AVAILABLE
  }
  case object modifying
      extends zio.aws.ec2.model.TransitGatewayPrefixListReferenceState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TransitGatewayPrefixListReferenceState =
      software.amazon.awssdk.services.ec2.model.TransitGatewayPrefixListReferenceState.MODIFYING
  }
  case object deleting
      extends zio.aws.ec2.model.TransitGatewayPrefixListReferenceState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TransitGatewayPrefixListReferenceState =
      software.amazon.awssdk.services.ec2.model.TransitGatewayPrefixListReferenceState.DELETING
  }
}
