package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ServiceDetail(
    serviceName: Optional[String] = Optional.Absent,
    serviceId: Optional[String] = Optional.Absent,
    serviceType: Optional[Iterable[zio.aws.ec2.model.ServiceTypeDetail]] =
      Optional.Absent,
    availabilityZones: Optional[Iterable[String]] = Optional.Absent,
    owner: Optional[String] = Optional.Absent,
    baseEndpointDnsNames: Optional[Iterable[String]] = Optional.Absent,
    privateDnsName: Optional[String] = Optional.Absent,
    privateDnsNames: Optional[Iterable[zio.aws.ec2.model.PrivateDnsDetails]] =
      Optional.Absent,
    vpcEndpointPolicySupported: Optional[Boolean] = Optional.Absent,
    acceptanceRequired: Optional[Boolean] = Optional.Absent,
    managesVpcEndpoints: Optional[Boolean] = Optional.Absent,
    payerResponsibility: Optional[zio.aws.ec2.model.PayerResponsibility] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent,
    privateDnsNameVerificationState: Optional[zio.aws.ec2.model.DnsNameState] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ServiceDetail = {
    import ServiceDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ServiceDetail
      .builder()
      .optionallyWith(serviceName.map(value => value: java.lang.String))(
        _.serviceName
      )
      .optionallyWith(serviceId.map(value => value: java.lang.String))(
        _.serviceId
      )
      .optionallyWith(
        serviceType.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.serviceType)
      .optionallyWith(
        availabilityZones.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.availabilityZones)
      .optionallyWith(owner.map(value => value: java.lang.String))(_.owner)
      .optionallyWith(
        baseEndpointDnsNames.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.baseEndpointDnsNames)
      .optionallyWith(privateDnsName.map(value => value: java.lang.String))(
        _.privateDnsName
      )
      .optionallyWith(
        privateDnsNames.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.privateDnsNames)
      .optionallyWith(
        vpcEndpointPolicySupported.map(value => value: java.lang.Boolean)
      )(_.vpcEndpointPolicySupported)
      .optionallyWith(
        acceptanceRequired.map(value => value: java.lang.Boolean)
      )(_.acceptanceRequired)
      .optionallyWith(
        managesVpcEndpoints.map(value => value: java.lang.Boolean)
      )(_.managesVpcEndpoints)
      .optionallyWith(payerResponsibility.map(value => value.unwrap))(
        _.payerResponsibility
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        privateDnsNameVerificationState.map(value => value.unwrap)
      )(_.privateDnsNameVerificationState)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ServiceDetail.ReadOnly =
    zio.aws.ec2.model.ServiceDetail.wrap(buildAwsValue())
}
object ServiceDetail {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.ServiceDetail] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ServiceDetail =
      zio.aws.ec2.model.ServiceDetail(
        serviceName.map(value => value),
        serviceId.map(value => value),
        serviceType.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        availabilityZones.map(value => value),
        owner.map(value => value),
        baseEndpointDnsNames.map(value => value),
        privateDnsName.map(value => value),
        privateDnsNames.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        vpcEndpointPolicySupported.map(value => value),
        acceptanceRequired.map(value => value),
        managesVpcEndpoints.map(value => value),
        payerResponsibility.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        privateDnsNameVerificationState.map(value => value)
      )
    def serviceName: Optional[String]
    def serviceId: Optional[String]
    def serviceType
        : Optional[List[zio.aws.ec2.model.ServiceTypeDetail.ReadOnly]]
    def availabilityZones: Optional[List[String]]
    def owner: Optional[String]
    def baseEndpointDnsNames: Optional[List[String]]
    def privateDnsName: Optional[String]
    def privateDnsNames
        : Optional[List[zio.aws.ec2.model.PrivateDnsDetails.ReadOnly]]
    def vpcEndpointPolicySupported: Optional[Boolean]
    def acceptanceRequired: Optional[Boolean]
    def managesVpcEndpoints: Optional[Boolean]
    def payerResponsibility: Optional[zio.aws.ec2.model.PayerResponsibility]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def privateDnsNameVerificationState
        : Optional[zio.aws.ec2.model.DnsNameState]
    def getServiceName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceName", serviceName)
    def getServiceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceId", serviceId)
    def getServiceType: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.ServiceTypeDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("serviceType", serviceType)
    def getAvailabilityZones: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("availabilityZones", availabilityZones)
    def getOwner: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("owner", owner)
    def getBaseEndpointDnsNames: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("baseEndpointDnsNames", baseEndpointDnsNames)
    def getPrivateDnsName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("privateDnsName", privateDnsName)
    def getPrivateDnsNames: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.PrivateDnsDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("privateDnsNames", privateDnsNames)
    def getVpcEndpointPolicySupported: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "vpcEndpointPolicySupported",
        vpcEndpointPolicySupported
      )
    def getAcceptanceRequired: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("acceptanceRequired", acceptanceRequired)
    def getManagesVpcEndpoints: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("managesVpcEndpoints", managesVpcEndpoints)
    def getPayerResponsibility
        : ZIO[Any, AwsError, zio.aws.ec2.model.PayerResponsibility] =
      AwsError.unwrapOptionField("payerResponsibility", payerResponsibility)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getPrivateDnsNameVerificationState
        : ZIO[Any, AwsError, zio.aws.ec2.model.DnsNameState] =
      AwsError.unwrapOptionField(
        "privateDnsNameVerificationState",
        privateDnsNameVerificationState
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ServiceDetail
  ) extends zio.aws.ec2.model.ServiceDetail.ReadOnly {
    override val serviceName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceName())
      .map(value => value: String)
    override val serviceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceId())
      .map(value => value: String)
    override val serviceType
        : Optional[List[zio.aws.ec2.model.ServiceTypeDetail.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceType())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.ServiceTypeDetail.wrap(item)
          }.toList
        )
    override val availabilityZones: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.availabilityZones())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val owner: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.owner())
      .map(value => value: String)
    override val baseEndpointDnsNames: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.baseEndpointDnsNames())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val privateDnsName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.privateDnsName())
      .map(value => value: String)
    override val privateDnsNames
        : Optional[List[zio.aws.ec2.model.PrivateDnsDetails.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.privateDnsNames())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.PrivateDnsDetails.wrap(item)
          }.toList
        )
    override val vpcEndpointPolicySupported: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcEndpointPolicySupported())
        .map(value => value: Boolean)
    override val acceptanceRequired: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.acceptanceRequired())
      .map(value => value: Boolean)
    override val managesVpcEndpoints: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.managesVpcEndpoints())
      .map(value => value: Boolean)
    override val payerResponsibility
        : Optional[zio.aws.ec2.model.PayerResponsibility] =
      zio.aws.core.internal
        .optionalFromNullable(impl.payerResponsibility())
        .map(value => zio.aws.ec2.model.PayerResponsibility.wrap(value))
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
    override val privateDnsNameVerificationState
        : Optional[zio.aws.ec2.model.DnsNameState] = zio.aws.core.internal
      .optionalFromNullable(impl.privateDnsNameVerificationState())
      .map(value => zio.aws.ec2.model.DnsNameState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ServiceDetail
  ): zio.aws.ec2.model.ServiceDetail.ReadOnly = new Wrapper(impl)
}
