package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SearchTransitGatewayMulticastGroupsResponse(
    multicastGroups: Optional[
      Iterable[zio.aws.ec2.model.TransitGatewayMulticastGroup]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.SearchTransitGatewayMulticastGroupsResponse = {
    import SearchTransitGatewayMulticastGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.SearchTransitGatewayMulticastGroupsResponse
      .builder()
      .optionallyWith(
        multicastGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.multicastGroups)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.SearchTransitGatewayMulticastGroupsResponse.ReadOnly =
    zio.aws.ec2.model.SearchTransitGatewayMulticastGroupsResponse
      .wrap(buildAwsValue())
}
object SearchTransitGatewayMulticastGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.SearchTransitGatewayMulticastGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.SearchTransitGatewayMulticastGroupsResponse =
      zio.aws.ec2.model.SearchTransitGatewayMulticastGroupsResponse(
        multicastGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def multicastGroups: Optional[
      List[zio.aws.ec2.model.TransitGatewayMulticastGroup.ReadOnly]
    ]
    def nextToken: Optional[String]
    def getMulticastGroups: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TransitGatewayMulticastGroup.ReadOnly
    ]] = AwsError.unwrapOptionField("multicastGroups", multicastGroups)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.SearchTransitGatewayMulticastGroupsResponse
  ) extends zio.aws.ec2.model.SearchTransitGatewayMulticastGroupsResponse.ReadOnly {
    override val multicastGroups: Optional[
      List[zio.aws.ec2.model.TransitGatewayMulticastGroup.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.multicastGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.TransitGatewayMulticastGroup.wrap(item)
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.SearchTransitGatewayMulticastGroupsResponse
  ): zio.aws.ec2.model.SearchTransitGatewayMulticastGroupsResponse.ReadOnly =
    new Wrapper(impl)
}
