package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{DateTime, Integer}
import scala.jdk.CollectionConverters._
final case class ScheduledInstanceAvailability(
    availabilityZone: Optional[String] = Optional.Absent,
    availableInstanceCount: Optional[Integer] = Optional.Absent,
    firstSlotStartTime: Optional[DateTime] = Optional.Absent,
    hourlyPrice: Optional[String] = Optional.Absent,
    instanceType: Optional[String] = Optional.Absent,
    maxTermDurationInDays: Optional[Integer] = Optional.Absent,
    minTermDurationInDays: Optional[Integer] = Optional.Absent,
    networkPlatform: Optional[String] = Optional.Absent,
    platform: Optional[String] = Optional.Absent,
    purchaseToken: Optional[String] = Optional.Absent,
    recurrence: Optional[zio.aws.ec2.model.ScheduledInstanceRecurrence] =
      Optional.Absent,
    slotDurationInHours: Optional[Integer] = Optional.Absent,
    totalScheduledInstanceHours: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ScheduledInstanceAvailability = {
    import ScheduledInstanceAvailability.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ScheduledInstanceAvailability
      .builder()
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(
        availableInstanceCount.map(value => value: java.lang.Integer)
      )(_.availableInstanceCount)
      .optionallyWith(
        firstSlotStartTime.map(value => DateTime.unwrap(value): Instant)
      )(_.firstSlotStartTime)
      .optionallyWith(hourlyPrice.map(value => value: java.lang.String))(
        _.hourlyPrice
      )
      .optionallyWith(instanceType.map(value => value: java.lang.String))(
        _.instanceType
      )
      .optionallyWith(
        maxTermDurationInDays.map(value => value: java.lang.Integer)
      )(_.maxTermDurationInDays)
      .optionallyWith(
        minTermDurationInDays.map(value => value: java.lang.Integer)
      )(_.minTermDurationInDays)
      .optionallyWith(networkPlatform.map(value => value: java.lang.String))(
        _.networkPlatform
      )
      .optionallyWith(platform.map(value => value: java.lang.String))(
        _.platform
      )
      .optionallyWith(purchaseToken.map(value => value: java.lang.String))(
        _.purchaseToken
      )
      .optionallyWith(recurrence.map(value => value.buildAwsValue()))(
        _.recurrence
      )
      .optionallyWith(
        slotDurationInHours.map(value => value: java.lang.Integer)
      )(_.slotDurationInHours)
      .optionallyWith(
        totalScheduledInstanceHours.map(value => value: java.lang.Integer)
      )(_.totalScheduledInstanceHours)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ScheduledInstanceAvailability.ReadOnly =
    zio.aws.ec2.model.ScheduledInstanceAvailability.wrap(buildAwsValue())
}
object ScheduledInstanceAvailability {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ScheduledInstanceAvailability
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ScheduledInstanceAvailability =
      zio.aws.ec2.model.ScheduledInstanceAvailability(
        availabilityZone.map(value => value),
        availableInstanceCount.map(value => value),
        firstSlotStartTime.map(value => value),
        hourlyPrice.map(value => value),
        instanceType.map(value => value),
        maxTermDurationInDays.map(value => value),
        minTermDurationInDays.map(value => value),
        networkPlatform.map(value => value),
        platform.map(value => value),
        purchaseToken.map(value => value),
        recurrence.map(value => value.asEditable),
        slotDurationInHours.map(value => value),
        totalScheduledInstanceHours.map(value => value)
      )
    def availabilityZone: Optional[String]
    def availableInstanceCount: Optional[Integer]
    def firstSlotStartTime: Optional[DateTime]
    def hourlyPrice: Optional[String]
    def instanceType: Optional[String]
    def maxTermDurationInDays: Optional[Integer]
    def minTermDurationInDays: Optional[Integer]
    def networkPlatform: Optional[String]
    def platform: Optional[String]
    def purchaseToken: Optional[String]
    def recurrence
        : Optional[zio.aws.ec2.model.ScheduledInstanceRecurrence.ReadOnly]
    def slotDurationInHours: Optional[Integer]
    def totalScheduledInstanceHours: Optional[Integer]
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getAvailableInstanceCount: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("availableInstanceCount", availableInstanceCount)
    def getFirstSlotStartTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("firstSlotStartTime", firstSlotStartTime)
    def getHourlyPrice: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("hourlyPrice", hourlyPrice)
    def getInstanceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getMaxTermDurationInDays: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxTermDurationInDays", maxTermDurationInDays)
    def getMinTermDurationInDays: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("minTermDurationInDays", minTermDurationInDays)
    def getNetworkPlatform: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("networkPlatform", networkPlatform)
    def getPlatform: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("platform", platform)
    def getPurchaseToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("purchaseToken", purchaseToken)
    def getRecurrence: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.ScheduledInstanceRecurrence.ReadOnly
    ] = AwsError.unwrapOptionField("recurrence", recurrence)
    def getSlotDurationInHours: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("slotDurationInHours", slotDurationInHours)
    def getTotalScheduledInstanceHours: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "totalScheduledInstanceHours",
        totalScheduledInstanceHours
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ScheduledInstanceAvailability
  ) extends zio.aws.ec2.model.ScheduledInstanceAvailability.ReadOnly {
    override val availabilityZone: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.availabilityZone())
      .map(value => value: String)
    override val availableInstanceCount: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.availableInstanceCount())
        .map(value => value: Integer)
    override val firstSlotStartTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.firstSlotStartTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val hourlyPrice: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.hourlyPrice())
      .map(value => value: String)
    override val instanceType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceType())
      .map(value => value: String)
    override val maxTermDurationInDays: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxTermDurationInDays())
        .map(value => value: Integer)
    override val minTermDurationInDays: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.minTermDurationInDays())
        .map(value => value: Integer)
    override val networkPlatform: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.networkPlatform())
      .map(value => value: String)
    override val platform: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.platform())
      .map(value => value: String)
    override val purchaseToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.purchaseToken())
      .map(value => value: String)
    override val recurrence
        : Optional[zio.aws.ec2.model.ScheduledInstanceRecurrence.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recurrence())
        .map(value => zio.aws.ec2.model.ScheduledInstanceRecurrence.wrap(value))
    override val slotDurationInHours: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.slotDurationInHours())
      .map(value => value: Integer)
    override val totalScheduledInstanceHours: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.totalScheduledInstanceHours())
        .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ScheduledInstanceAvailability
  ): zio.aws.ec2.model.ScheduledInstanceAvailability.ReadOnly = new Wrapper(
    impl
  )
}
