package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ReservedInstancesOffering(
    availabilityZone: Optional[String] = Optional.Absent,
    duration: Optional[Long] = Optional.Absent,
    fixedPrice: Optional[Float] = Optional.Absent,
    instanceType: Optional[zio.aws.ec2.model.InstanceType] = Optional.Absent,
    productDescription: Optional[zio.aws.ec2.model.RIProductDescription] =
      Optional.Absent,
    reservedInstancesOfferingId: Optional[String] = Optional.Absent,
    usagePrice: Optional[Float] = Optional.Absent,
    currencyCode: Optional[zio.aws.ec2.model.CurrencyCodeValues] =
      Optional.Absent,
    instanceTenancy: Optional[zio.aws.ec2.model.Tenancy] = Optional.Absent,
    marketplace: Optional[Boolean] = Optional.Absent,
    offeringClass: Optional[zio.aws.ec2.model.OfferingClassType] =
      Optional.Absent,
    offeringType: Optional[zio.aws.ec2.model.OfferingTypeValues] =
      Optional.Absent,
    pricingDetails: Optional[Iterable[zio.aws.ec2.model.PricingDetail]] =
      Optional.Absent,
    recurringCharges: Optional[Iterable[zio.aws.ec2.model.RecurringCharge]] =
      Optional.Absent,
    scope: Optional[zio.aws.ec2.model.Scope] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ReservedInstancesOffering = {
    import ReservedInstancesOffering.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ReservedInstancesOffering
      .builder()
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(duration.map(value => value: java.lang.Long))(_.duration)
      .optionallyWith(fixedPrice.map(value => value: java.lang.Float))(
        _.fixedPrice
      )
      .optionallyWith(instanceType.map(value => value.unwrap))(_.instanceType)
      .optionallyWith(productDescription.map(value => value.unwrap))(
        _.productDescription
      )
      .optionallyWith(
        reservedInstancesOfferingId.map(value => value: java.lang.String)
      )(_.reservedInstancesOfferingId)
      .optionallyWith(usagePrice.map(value => value: java.lang.Float))(
        _.usagePrice
      )
      .optionallyWith(currencyCode.map(value => value.unwrap))(_.currencyCode)
      .optionallyWith(instanceTenancy.map(value => value.unwrap))(
        _.instanceTenancy
      )
      .optionallyWith(marketplace.map(value => value: java.lang.Boolean))(
        _.marketplace
      )
      .optionallyWith(offeringClass.map(value => value.unwrap))(_.offeringClass)
      .optionallyWith(offeringType.map(value => value.unwrap))(_.offeringType)
      .optionallyWith(
        pricingDetails.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.pricingDetails)
      .optionallyWith(
        recurringCharges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.recurringCharges)
      .optionallyWith(scope.map(value => value.unwrap))(_.scope)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ReservedInstancesOffering.ReadOnly =
    zio.aws.ec2.model.ReservedInstancesOffering.wrap(buildAwsValue())
}
object ReservedInstancesOffering {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ReservedInstancesOffering
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ReservedInstancesOffering =
      zio.aws.ec2.model.ReservedInstancesOffering(
        availabilityZone.map(value => value),
        duration.map(value => value),
        fixedPrice.map(value => value),
        instanceType.map(value => value),
        productDescription.map(value => value),
        reservedInstancesOfferingId.map(value => value),
        usagePrice.map(value => value),
        currencyCode.map(value => value),
        instanceTenancy.map(value => value),
        marketplace.map(value => value),
        offeringClass.map(value => value),
        offeringType.map(value => value),
        pricingDetails.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        recurringCharges.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        scope.map(value => value)
      )
    def availabilityZone: Optional[String]
    def duration: Optional[Long]
    def fixedPrice: Optional[Float]
    def instanceType: Optional[zio.aws.ec2.model.InstanceType]
    def productDescription: Optional[zio.aws.ec2.model.RIProductDescription]
    def reservedInstancesOfferingId: Optional[String]
    def usagePrice: Optional[Float]
    def currencyCode: Optional[zio.aws.ec2.model.CurrencyCodeValues]
    def instanceTenancy: Optional[zio.aws.ec2.model.Tenancy]
    def marketplace: Optional[Boolean]
    def offeringClass: Optional[zio.aws.ec2.model.OfferingClassType]
    def offeringType: Optional[zio.aws.ec2.model.OfferingTypeValues]
    def pricingDetails: Optional[List[zio.aws.ec2.model.PricingDetail.ReadOnly]]
    def recurringCharges
        : Optional[List[zio.aws.ec2.model.RecurringCharge.ReadOnly]]
    def scope: Optional[zio.aws.ec2.model.Scope]
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getDuration: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("duration", duration)
    def getFixedPrice: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("fixedPrice", fixedPrice)
    def getInstanceType: ZIO[Any, AwsError, zio.aws.ec2.model.InstanceType] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getProductDescription
        : ZIO[Any, AwsError, zio.aws.ec2.model.RIProductDescription] =
      AwsError.unwrapOptionField("productDescription", productDescription)
    def getReservedInstancesOfferingId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "reservedInstancesOfferingId",
        reservedInstancesOfferingId
      )
    def getUsagePrice: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("usagePrice", usagePrice)
    def getCurrencyCode
        : ZIO[Any, AwsError, zio.aws.ec2.model.CurrencyCodeValues] =
      AwsError.unwrapOptionField("currencyCode", currencyCode)
    def getInstanceTenancy: ZIO[Any, AwsError, zio.aws.ec2.model.Tenancy] =
      AwsError.unwrapOptionField("instanceTenancy", instanceTenancy)
    def getMarketplace: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("marketplace", marketplace)
    def getOfferingClass
        : ZIO[Any, AwsError, zio.aws.ec2.model.OfferingClassType] =
      AwsError.unwrapOptionField("offeringClass", offeringClass)
    def getOfferingType
        : ZIO[Any, AwsError, zio.aws.ec2.model.OfferingTypeValues] =
      AwsError.unwrapOptionField("offeringType", offeringType)
    def getPricingDetails
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.PricingDetail.ReadOnly]] =
      AwsError.unwrapOptionField("pricingDetails", pricingDetails)
    def getRecurringCharges
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.RecurringCharge.ReadOnly]] =
      AwsError.unwrapOptionField("recurringCharges", recurringCharges)
    def getScope: ZIO[Any, AwsError, zio.aws.ec2.model.Scope] =
      AwsError.unwrapOptionField("scope", scope)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ReservedInstancesOffering
  ) extends zio.aws.ec2.model.ReservedInstancesOffering.ReadOnly {
    override val availabilityZone: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.availabilityZone())
      .map(value => value: String)
    override val duration: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.duration())
      .map(value => value: Long)
    override val fixedPrice: Optional[Float] = zio.aws.core.internal
      .optionalFromNullable(impl.fixedPrice())
      .map(value => value: Float)
    override val instanceType: Optional[zio.aws.ec2.model.InstanceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceType())
        .map(value => zio.aws.ec2.model.InstanceType.wrap(value))
    override val productDescription
        : Optional[zio.aws.ec2.model.RIProductDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.productDescription())
        .map(value => zio.aws.ec2.model.RIProductDescription.wrap(value))
    override val reservedInstancesOfferingId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reservedInstancesOfferingId())
        .map(value => value: String)
    override val usagePrice: Optional[Float] = zio.aws.core.internal
      .optionalFromNullable(impl.usagePrice())
      .map(value => value: Float)
    override val currencyCode: Optional[zio.aws.ec2.model.CurrencyCodeValues] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currencyCode())
        .map(value => zio.aws.ec2.model.CurrencyCodeValues.wrap(value))
    override val instanceTenancy: Optional[zio.aws.ec2.model.Tenancy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceTenancy())
        .map(value => zio.aws.ec2.model.Tenancy.wrap(value))
    override val marketplace: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.marketplace())
      .map(value => value: Boolean)
    override val offeringClass: Optional[zio.aws.ec2.model.OfferingClassType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.offeringClass())
        .map(value => zio.aws.ec2.model.OfferingClassType.wrap(value))
    override val offeringType: Optional[zio.aws.ec2.model.OfferingTypeValues] =
      zio.aws.core.internal
        .optionalFromNullable(impl.offeringType())
        .map(value => zio.aws.ec2.model.OfferingTypeValues.wrap(value))
    override val pricingDetails
        : Optional[List[zio.aws.ec2.model.PricingDetail.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pricingDetails())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.PricingDetail.wrap(item)
          }.toList
        )
    override val recurringCharges
        : Optional[List[zio.aws.ec2.model.RecurringCharge.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recurringCharges())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.RecurringCharge.wrap(item)
          }.toList
        )
    override val scope: Optional[zio.aws.ec2.model.Scope] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scope())
        .map(value => zio.aws.ec2.model.Scope.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ReservedInstancesOffering
  ): zio.aws.ec2.model.ReservedInstancesOffering.ReadOnly = new Wrapper(impl)
}
