package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Reservation(
    groups: Optional[Iterable[zio.aws.ec2.model.GroupIdentifier]] =
      Optional.Absent,
    instances: Optional[Iterable[zio.aws.ec2.model.Instance]] = Optional.Absent,
    ownerId: Optional[String] = Optional.Absent,
    requesterId: Optional[String] = Optional.Absent,
    reservationId: Optional[String] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.Reservation = {
    import Reservation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.Reservation
      .builder()
      .optionallyWith(
        groups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.groups)
      .optionallyWith(
        instances.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instances)
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .optionallyWith(requesterId.map(value => value: java.lang.String))(
        _.requesterId
      )
      .optionallyWith(reservationId.map(value => value: java.lang.String))(
        _.reservationId
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.Reservation.ReadOnly =
    zio.aws.ec2.model.Reservation.wrap(buildAwsValue())
}
object Reservation {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.Reservation] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.Reservation =
      zio.aws.ec2.model.Reservation(
        groups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        instances.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ownerId.map(value => value),
        requesterId.map(value => value),
        reservationId.map(value => value)
      )
    def groups: Optional[List[zio.aws.ec2.model.GroupIdentifier.ReadOnly]]
    def instances: Optional[List[zio.aws.ec2.model.Instance.ReadOnly]]
    def ownerId: Optional[String]
    def requesterId: Optional[String]
    def reservationId: Optional[String]
    def getGroups
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.GroupIdentifier.ReadOnly]] =
      AwsError.unwrapOptionField("groups", groups)
    def getInstances
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Instance.ReadOnly]] =
      AwsError.unwrapOptionField("instances", instances)
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getRequesterId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("requesterId", requesterId)
    def getReservationId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("reservationId", reservationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.Reservation
  ) extends zio.aws.ec2.model.Reservation.ReadOnly {
    override val groups
        : Optional[List[zio.aws.ec2.model.GroupIdentifier.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.groups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.GroupIdentifier.wrap(item)
          }.toList
        )
    override val instances
        : Optional[List[zio.aws.ec2.model.Instance.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instances())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Instance.wrap(item)
          }.toList
        )
    override val ownerId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerId())
      .map(value => value: String)
    override val requesterId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.requesterId())
      .map(value => value: String)
    override val reservationId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.reservationId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.Reservation
  ): zio.aws.ec2.model.Reservation.ReadOnly = new Wrapper(impl)
}
