package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PropagatingVgw(gatewayId: Optional[String] = Optional.Absent) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.PropagatingVgw = {
    import PropagatingVgw.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.PropagatingVgw
      .builder()
      .optionallyWith(gatewayId.map(value => value: java.lang.String))(
        _.gatewayId
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.PropagatingVgw.ReadOnly =
    zio.aws.ec2.model.PropagatingVgw.wrap(buildAwsValue())
}
object PropagatingVgw {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.PropagatingVgw
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.PropagatingVgw =
      zio.aws.ec2.model.PropagatingVgw(gatewayId.map(value => value))
    def gatewayId: Optional[String]
    def getGatewayId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("gatewayId", gatewayId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.PropagatingVgw
  ) extends zio.aws.ec2.model.PropagatingVgw.ReadOnly {
    override val gatewayId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.gatewayId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.PropagatingVgw
  ): zio.aws.ec2.model.PropagatingVgw.ReadOnly = new Wrapper(impl)
}
