package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  MaxNetworkInterfaces,
  NetworkPerformance,
  NetworkCardIndex
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class NetworkCardInfo(
    networkCardIndex: Optional[NetworkCardIndex] = Optional.Absent,
    networkPerformance: Optional[NetworkPerformance] = Optional.Absent,
    maximumNetworkInterfaces: Optional[MaxNetworkInterfaces] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.NetworkCardInfo = {
    import NetworkCardInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.NetworkCardInfo
      .builder()
      .optionallyWith(
        networkCardIndex.map(value => NetworkCardIndex.unwrap(value): Integer)
      )(_.networkCardIndex)
      .optionallyWith(
        networkPerformance.map(value =>
          NetworkPerformance.unwrap(value): java.lang.String
        )
      )(_.networkPerformance)
      .optionallyWith(
        maximumNetworkInterfaces.map(value =>
          MaxNetworkInterfaces.unwrap(value): Integer
        )
      )(_.maximumNetworkInterfaces)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.NetworkCardInfo.ReadOnly =
    zio.aws.ec2.model.NetworkCardInfo.wrap(buildAwsValue())
}
object NetworkCardInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.NetworkCardInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.NetworkCardInfo =
      zio.aws.ec2.model.NetworkCardInfo(
        networkCardIndex.map(value => value),
        networkPerformance.map(value => value),
        maximumNetworkInterfaces.map(value => value)
      )
    def networkCardIndex: Optional[NetworkCardIndex]
    def networkPerformance: Optional[NetworkPerformance]
    def maximumNetworkInterfaces: Optional[MaxNetworkInterfaces]
    def getNetworkCardIndex: ZIO[Any, AwsError, NetworkCardIndex] =
      AwsError.unwrapOptionField("networkCardIndex", networkCardIndex)
    def getNetworkPerformance: ZIO[Any, AwsError, NetworkPerformance] =
      AwsError.unwrapOptionField("networkPerformance", networkPerformance)
    def getMaximumNetworkInterfaces: ZIO[Any, AwsError, MaxNetworkInterfaces] =
      AwsError.unwrapOptionField(
        "maximumNetworkInterfaces",
        maximumNetworkInterfaces
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.NetworkCardInfo
  ) extends zio.aws.ec2.model.NetworkCardInfo.ReadOnly {
    override val networkCardIndex: Optional[NetworkCardIndex] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkCardIndex())
        .map(value => zio.aws.ec2.model.primitives.NetworkCardIndex(value))
    override val networkPerformance: Optional[NetworkPerformance] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkPerformance())
        .map(value => zio.aws.ec2.model.primitives.NetworkPerformance(value))
    override val maximumNetworkInterfaces: Optional[MaxNetworkInterfaces] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maximumNetworkInterfaces())
        .map(value => zio.aws.ec2.model.primitives.MaxNetworkInterfaces(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.NetworkCardInfo
  ): zio.aws.ec2.model.NetworkCardInfo.ReadOnly = new Wrapper(impl)
}
