package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.IpamPoolId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class MoveByoipCidrToIpamRequest(
    cidr: String,
    ipamPoolId: IpamPoolId,
    ipamPoolOwner: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.MoveByoipCidrToIpamRequest = {
    import MoveByoipCidrToIpamRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.MoveByoipCidrToIpamRequest
      .builder()
      .cidr(cidr: java.lang.String)
      .ipamPoolId(IpamPoolId.unwrap(ipamPoolId): java.lang.String)
      .ipamPoolOwner(ipamPoolOwner: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.MoveByoipCidrToIpamRequest.ReadOnly =
    zio.aws.ec2.model.MoveByoipCidrToIpamRequest.wrap(buildAwsValue())
}
object MoveByoipCidrToIpamRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.MoveByoipCidrToIpamRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.MoveByoipCidrToIpamRequest =
      zio.aws.ec2.model
        .MoveByoipCidrToIpamRequest(cidr, ipamPoolId, ipamPoolOwner)
    def cidr: String
    def ipamPoolId: IpamPoolId
    def ipamPoolOwner: String
    def getCidr: ZIO[Any, Nothing, String] = ZIO.succeed(cidr)
    def getIpamPoolId: ZIO[Any, Nothing, IpamPoolId] = ZIO.succeed(ipamPoolId)
    def getIpamPoolOwner: ZIO[Any, Nothing, String] = ZIO.succeed(ipamPoolOwner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.MoveByoipCidrToIpamRequest
  ) extends zio.aws.ec2.model.MoveByoipCidrToIpamRequest.ReadOnly {
    override val cidr: String = impl.cidr(): String
    override val ipamPoolId: IpamPoolId =
      zio.aws.ec2.model.primitives.IpamPoolId(impl.ipamPoolId())
    override val ipamPoolOwner: String = impl.ipamPoolOwner(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.MoveByoipCidrToIpamRequest
  ): zio.aws.ec2.model.MoveByoipCidrToIpamRequest.ReadOnly = new Wrapper(impl)
}
