package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  Integer,
  TrafficMirrorFilterId,
  TrafficMirrorTargetId,
  TrafficMirrorSessionId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyTrafficMirrorSessionRequest(
    trafficMirrorSessionId: TrafficMirrorSessionId,
    trafficMirrorTargetId: Optional[TrafficMirrorTargetId] = Optional.Absent,
    trafficMirrorFilterId: Optional[TrafficMirrorFilterId] = Optional.Absent,
    packetLength: Optional[Integer] = Optional.Absent,
    sessionNumber: Optional[Integer] = Optional.Absent,
    virtualNetworkId: Optional[Integer] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    removeFields: Optional[
      Iterable[zio.aws.ec2.model.TrafficMirrorSessionField]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyTrafficMirrorSessionRequest = {
    import ModifyTrafficMirrorSessionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyTrafficMirrorSessionRequest
      .builder()
      .trafficMirrorSessionId(
        TrafficMirrorSessionId.unwrap(trafficMirrorSessionId): java.lang.String
      )
      .optionallyWith(
        trafficMirrorTargetId.map(value =>
          TrafficMirrorTargetId.unwrap(value): java.lang.String
        )
      )(_.trafficMirrorTargetId)
      .optionallyWith(
        trafficMirrorFilterId.map(value =>
          TrafficMirrorFilterId.unwrap(value): java.lang.String
        )
      )(_.trafficMirrorFilterId)
      .optionallyWith(packetLength.map(value => value: java.lang.Integer))(
        _.packetLength
      )
      .optionallyWith(sessionNumber.map(value => value: java.lang.Integer))(
        _.sessionNumber
      )
      .optionallyWith(virtualNetworkId.map(value => value: java.lang.Integer))(
        _.virtualNetworkId
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        removeFields.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.removeFieldsWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifyTrafficMirrorSessionRequest.ReadOnly =
    zio.aws.ec2.model.ModifyTrafficMirrorSessionRequest.wrap(buildAwsValue())
}
object ModifyTrafficMirrorSessionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyTrafficMirrorSessionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyTrafficMirrorSessionRequest =
      zio.aws.ec2.model.ModifyTrafficMirrorSessionRequest(
        trafficMirrorSessionId,
        trafficMirrorTargetId.map(value => value),
        trafficMirrorFilterId.map(value => value),
        packetLength.map(value => value),
        sessionNumber.map(value => value),
        virtualNetworkId.map(value => value),
        description.map(value => value),
        removeFields.map(value => value)
      )
    def trafficMirrorSessionId: TrafficMirrorSessionId
    def trafficMirrorTargetId: Optional[TrafficMirrorTargetId]
    def trafficMirrorFilterId: Optional[TrafficMirrorFilterId]
    def packetLength: Optional[Integer]
    def sessionNumber: Optional[Integer]
    def virtualNetworkId: Optional[Integer]
    def description: Optional[String]
    def removeFields
        : Optional[List[zio.aws.ec2.model.TrafficMirrorSessionField]]
    def getTrafficMirrorSessionId: ZIO[Any, Nothing, TrafficMirrorSessionId] =
      ZIO.succeed(trafficMirrorSessionId)
    def getTrafficMirrorTargetId: ZIO[Any, AwsError, TrafficMirrorTargetId] =
      AwsError.unwrapOptionField("trafficMirrorTargetId", trafficMirrorTargetId)
    def getTrafficMirrorFilterId: ZIO[Any, AwsError, TrafficMirrorFilterId] =
      AwsError.unwrapOptionField("trafficMirrorFilterId", trafficMirrorFilterId)
    def getPacketLength: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("packetLength", packetLength)
    def getSessionNumber: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("sessionNumber", sessionNumber)
    def getVirtualNetworkId: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("virtualNetworkId", virtualNetworkId)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getRemoveFields: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TrafficMirrorSessionField
    ]] = AwsError.unwrapOptionField("removeFields", removeFields)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyTrafficMirrorSessionRequest
  ) extends zio.aws.ec2.model.ModifyTrafficMirrorSessionRequest.ReadOnly {
    override val trafficMirrorSessionId: TrafficMirrorSessionId =
      zio.aws.ec2.model.primitives
        .TrafficMirrorSessionId(impl.trafficMirrorSessionId())
    override val trafficMirrorTargetId: Optional[TrafficMirrorTargetId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trafficMirrorTargetId())
        .map(value => zio.aws.ec2.model.primitives.TrafficMirrorTargetId(value))
    override val trafficMirrorFilterId: Optional[TrafficMirrorFilterId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trafficMirrorFilterId())
        .map(value => zio.aws.ec2.model.primitives.TrafficMirrorFilterId(value))
    override val packetLength: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.packetLength())
      .map(value => value: Integer)
    override val sessionNumber: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.sessionNumber())
      .map(value => value: Integer)
    override val virtualNetworkId: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.virtualNetworkId())
      .map(value => value: Integer)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val removeFields
        : Optional[List[zio.aws.ec2.model.TrafficMirrorSessionField]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.removeFields())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TrafficMirrorSessionField.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyTrafficMirrorSessionRequest
  ): zio.aws.ec2.model.ModifyTrafficMirrorSessionRequest.ReadOnly = new Wrapper(
    impl
  )
}
