package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InstanceCount(
    instanceCount: Optional[Integer] = Optional.Absent,
    state: Optional[zio.aws.ec2.model.ListingState] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.InstanceCount = {
    import InstanceCount.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.InstanceCount
      .builder()
      .optionallyWith(instanceCount.map(value => value: java.lang.Integer))(
        _.instanceCount
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.InstanceCount.ReadOnly =
    zio.aws.ec2.model.InstanceCount.wrap(buildAwsValue())
}
object InstanceCount {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.InstanceCount] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.InstanceCount =
      zio.aws.ec2.model.InstanceCount(
        instanceCount.map(value => value),
        state.map(value => value)
      )
    def instanceCount: Optional[Integer]
    def state: Optional[zio.aws.ec2.model.ListingState]
    def getInstanceCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("instanceCount", instanceCount)
    def getState: ZIO[Any, AwsError, zio.aws.ec2.model.ListingState] =
      AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.InstanceCount
  ) extends zio.aws.ec2.model.InstanceCount.ReadOnly {
    override val instanceCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceCount())
      .map(value => value: Integer)
    override val state: Optional[zio.aws.ec2.model.ListingState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.ec2.model.ListingState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.InstanceCount
  ): zio.aws.ec2.model.InstanceCount.ReadOnly = new Wrapper(impl)
}
