package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ImportImageLicenseConfigurationResponse(
    licenseConfigurationArn: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ImportImageLicenseConfigurationResponse = {
    import ImportImageLicenseConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ImportImageLicenseConfigurationResponse
      .builder()
      .optionallyWith(
        licenseConfigurationArn.map(value => value: java.lang.String)
      )(_.licenseConfigurationArn)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ImportImageLicenseConfigurationResponse.ReadOnly =
    zio.aws.ec2.model.ImportImageLicenseConfigurationResponse
      .wrap(buildAwsValue())
}
object ImportImageLicenseConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ImportImageLicenseConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ImportImageLicenseConfigurationResponse =
      zio.aws.ec2.model.ImportImageLicenseConfigurationResponse(
        licenseConfigurationArn.map(value => value)
      )
    def licenseConfigurationArn: Optional[String]
    def getLicenseConfigurationArn: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("licenseConfigurationArn", licenseConfigurationArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ImportImageLicenseConfigurationResponse
  ) extends zio.aws.ec2.model.ImportImageLicenseConfigurationResponse.ReadOnly {
    override val licenseConfigurationArn: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.licenseConfigurationArn())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ImportImageLicenseConfigurationResponse
  ): zio.aws.ec2.model.ImportImageLicenseConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
