package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ExportImageTask(
    description: Optional[String] = Optional.Absent,
    exportImageTaskId: Optional[String] = Optional.Absent,
    imageId: Optional[String] = Optional.Absent,
    progress: Optional[String] = Optional.Absent,
    s3ExportLocation: Optional[zio.aws.ec2.model.ExportTaskS3Location] =
      Optional.Absent,
    status: Optional[String] = Optional.Absent,
    statusMessage: Optional[String] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ExportImageTask = {
    import ExportImageTask.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ExportImageTask
      .builder()
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(exportImageTaskId.map(value => value: java.lang.String))(
        _.exportImageTaskId
      )
      .optionallyWith(imageId.map(value => value: java.lang.String))(_.imageId)
      .optionallyWith(progress.map(value => value: java.lang.String))(
        _.progress
      )
      .optionallyWith(s3ExportLocation.map(value => value.buildAwsValue()))(
        _.s3ExportLocation
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(statusMessage.map(value => value: java.lang.String))(
        _.statusMessage
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ExportImageTask.ReadOnly =
    zio.aws.ec2.model.ExportImageTask.wrap(buildAwsValue())
}
object ExportImageTask {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ExportImageTask
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ExportImageTask =
      zio.aws.ec2.model.ExportImageTask(
        description.map(value => value),
        exportImageTaskId.map(value => value),
        imageId.map(value => value),
        progress.map(value => value),
        s3ExportLocation.map(value => value.asEditable),
        status.map(value => value),
        statusMessage.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def description: Optional[String]
    def exportImageTaskId: Optional[String]
    def imageId: Optional[String]
    def progress: Optional[String]
    def s3ExportLocation
        : Optional[zio.aws.ec2.model.ExportTaskS3Location.ReadOnly]
    def status: Optional[String]
    def statusMessage: Optional[String]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getExportImageTaskId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("exportImageTaskId", exportImageTaskId)
    def getImageId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("imageId", imageId)
    def getProgress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("progress", progress)
    def getS3ExportLocation
        : ZIO[Any, AwsError, zio.aws.ec2.model.ExportTaskS3Location.ReadOnly] =
      AwsError.unwrapOptionField("s3ExportLocation", s3ExportLocation)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ExportImageTask
  ) extends zio.aws.ec2.model.ExportImageTask.ReadOnly {
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val exportImageTaskId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.exportImageTaskId())
      .map(value => value: String)
    override val imageId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.imageId())
      .map(value => value: String)
    override val progress: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.progress())
      .map(value => value: String)
    override val s3ExportLocation
        : Optional[zio.aws.ec2.model.ExportTaskS3Location.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3ExportLocation())
        .map(value => zio.aws.ec2.model.ExportTaskS3Location.wrap(value))
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val statusMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value => value: String)
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ExportImageTask
  ): zio.aws.ec2.model.ExportImageTask.ReadOnly = new Wrapper(impl)
}
