package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DisassociateVpcCidrBlockResponse(
    ipv6CidrBlockAssociation: Optional[
      zio.aws.ec2.model.VpcIpv6CidrBlockAssociation
    ] = Optional.Absent,
    cidrBlockAssociation: Optional[zio.aws.ec2.model.VpcCidrBlockAssociation] =
      Optional.Absent,
    vpcId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DisassociateVpcCidrBlockResponse = {
    import DisassociateVpcCidrBlockResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DisassociateVpcCidrBlockResponse
      .builder()
      .optionallyWith(
        ipv6CidrBlockAssociation.map(value => value.buildAwsValue())
      )(_.ipv6CidrBlockAssociation)
      .optionallyWith(cidrBlockAssociation.map(value => value.buildAwsValue()))(
        _.cidrBlockAssociation
      )
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DisassociateVpcCidrBlockResponse.ReadOnly =
    zio.aws.ec2.model.DisassociateVpcCidrBlockResponse.wrap(buildAwsValue())
}
object DisassociateVpcCidrBlockResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DisassociateVpcCidrBlockResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DisassociateVpcCidrBlockResponse =
      zio.aws.ec2.model.DisassociateVpcCidrBlockResponse(
        ipv6CidrBlockAssociation.map(value => value.asEditable),
        cidrBlockAssociation.map(value => value.asEditable),
        vpcId.map(value => value)
      )
    def ipv6CidrBlockAssociation
        : Optional[zio.aws.ec2.model.VpcIpv6CidrBlockAssociation.ReadOnly]
    def cidrBlockAssociation
        : Optional[zio.aws.ec2.model.VpcCidrBlockAssociation.ReadOnly]
    def vpcId: Optional[String]
    def getIpv6CidrBlockAssociation: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.VpcIpv6CidrBlockAssociation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "ipv6CidrBlockAssociation",
      ipv6CidrBlockAssociation
    )
    def getCidrBlockAssociation: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.VpcCidrBlockAssociation.ReadOnly
    ] = AwsError.unwrapOptionField("cidrBlockAssociation", cidrBlockAssociation)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DisassociateVpcCidrBlockResponse
  ) extends zio.aws.ec2.model.DisassociateVpcCidrBlockResponse.ReadOnly {
    override val ipv6CidrBlockAssociation
        : Optional[zio.aws.ec2.model.VpcIpv6CidrBlockAssociation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipv6CidrBlockAssociation())
        .map(value => zio.aws.ec2.model.VpcIpv6CidrBlockAssociation.wrap(value))
    override val cidrBlockAssociation
        : Optional[zio.aws.ec2.model.VpcCidrBlockAssociation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cidrBlockAssociation())
        .map(value => zio.aws.ec2.model.VpcCidrBlockAssociation.wrap(value))
    override val vpcId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DisassociateVpcCidrBlockResponse
  ): zio.aws.ec2.model.DisassociateVpcCidrBlockResponse.ReadOnly = new Wrapper(
    impl
  )
}
