package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeMovingAddressesResponse(
    movingAddressStatuses: Optional[
      Iterable[zio.aws.ec2.model.MovingAddressStatus]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeMovingAddressesResponse = {
    import DescribeMovingAddressesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeMovingAddressesResponse
      .builder()
      .optionallyWith(
        movingAddressStatuses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.movingAddressStatuses)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeMovingAddressesResponse.ReadOnly =
    zio.aws.ec2.model.DescribeMovingAddressesResponse.wrap(buildAwsValue())
}
object DescribeMovingAddressesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeMovingAddressesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeMovingAddressesResponse =
      zio.aws.ec2.model.DescribeMovingAddressesResponse(
        movingAddressStatuses.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def movingAddressStatuses
        : Optional[List[zio.aws.ec2.model.MovingAddressStatus.ReadOnly]]
    def nextToken: Optional[String]
    def getMovingAddressStatuses: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.MovingAddressStatus.ReadOnly
    ]] =
      AwsError.unwrapOptionField("movingAddressStatuses", movingAddressStatuses)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeMovingAddressesResponse
  ) extends zio.aws.ec2.model.DescribeMovingAddressesResponse.ReadOnly {
    override val movingAddressStatuses
        : Optional[List[zio.aws.ec2.model.MovingAddressStatus.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.movingAddressStatuses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.MovingAddressStatus.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeMovingAddressesResponse
  ): zio.aws.ec2.model.DescribeMovingAddressesResponse.ReadOnly = new Wrapper(
    impl
  )
}
