package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeletePublicIpv4PoolResponse(
    returnValue: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeletePublicIpv4PoolResponse = {
    import DeletePublicIpv4PoolResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeletePublicIpv4PoolResponse
      .builder()
      .optionallyWith(returnValue.map(value => value: java.lang.Boolean))(
        _.returnValue
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeletePublicIpv4PoolResponse.ReadOnly =
    zio.aws.ec2.model.DeletePublicIpv4PoolResponse.wrap(buildAwsValue())
}
object DeletePublicIpv4PoolResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeletePublicIpv4PoolResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeletePublicIpv4PoolResponse =
      zio.aws.ec2.model
        .DeletePublicIpv4PoolResponse(returnValue.map(value => value))
    def returnValue: Optional[Boolean]
    def getReturnValue: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("returnValue", returnValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeletePublicIpv4PoolResponse
  ) extends zio.aws.ec2.model.DeletePublicIpv4PoolResponse.ReadOnly {
    override val returnValue: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.returnValue())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeletePublicIpv4PoolResponse
  ): zio.aws.ec2.model.DeletePublicIpv4PoolResponse.ReadOnly = new Wrapper(impl)
}
