package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ClientVpnAuthentication(
    `type`: Optional[zio.aws.ec2.model.ClientVpnAuthenticationType] =
      Optional.Absent,
    activeDirectory: Optional[
      zio.aws.ec2.model.DirectoryServiceAuthentication
    ] = Optional.Absent,
    mutualAuthentication: Optional[
      zio.aws.ec2.model.CertificateAuthentication
    ] = Optional.Absent,
    federatedAuthentication: Optional[
      zio.aws.ec2.model.FederatedAuthentication
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ClientVpnAuthentication = {
    import ClientVpnAuthentication.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ClientVpnAuthentication
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(activeDirectory.map(value => value.buildAwsValue()))(
        _.activeDirectory
      )
      .optionallyWith(mutualAuthentication.map(value => value.buildAwsValue()))(
        _.mutualAuthentication
      )
      .optionallyWith(
        federatedAuthentication.map(value => value.buildAwsValue())
      )(_.federatedAuthentication)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ClientVpnAuthentication.ReadOnly =
    zio.aws.ec2.model.ClientVpnAuthentication.wrap(buildAwsValue())
}
object ClientVpnAuthentication {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ClientVpnAuthentication
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ClientVpnAuthentication =
      zio.aws.ec2.model.ClientVpnAuthentication(
        `type`.map(value => value),
        activeDirectory.map(value => value.asEditable),
        mutualAuthentication.map(value => value.asEditable),
        federatedAuthentication.map(value => value.asEditable)
      )
    def `type`: Optional[zio.aws.ec2.model.ClientVpnAuthenticationType]
    def activeDirectory
        : Optional[zio.aws.ec2.model.DirectoryServiceAuthentication.ReadOnly]
    def mutualAuthentication
        : Optional[zio.aws.ec2.model.CertificateAuthentication.ReadOnly]
    def federatedAuthentication
        : Optional[zio.aws.ec2.model.FederatedAuthentication.ReadOnly]
    def getType
        : ZIO[Any, AwsError, zio.aws.ec2.model.ClientVpnAuthenticationType] =
      AwsError.unwrapOptionField("type", `type`)
    def getActiveDirectory: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.DirectoryServiceAuthentication.ReadOnly
    ] = AwsError.unwrapOptionField("activeDirectory", activeDirectory)
    def getMutualAuthentication: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.CertificateAuthentication.ReadOnly
    ] = AwsError.unwrapOptionField("mutualAuthentication", mutualAuthentication)
    def getFederatedAuthentication: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.FederatedAuthentication.ReadOnly
    ] = AwsError.unwrapOptionField(
      "federatedAuthentication",
      federatedAuthentication
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ClientVpnAuthentication
  ) extends zio.aws.ec2.model.ClientVpnAuthentication.ReadOnly {
    override val `type`
        : Optional[zio.aws.ec2.model.ClientVpnAuthenticationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.ec2.model.ClientVpnAuthenticationType.wrap(value))
    override val activeDirectory
        : Optional[zio.aws.ec2.model.DirectoryServiceAuthentication.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.activeDirectory())
        .map(value =>
          zio.aws.ec2.model.DirectoryServiceAuthentication.wrap(value)
        )
    override val mutualAuthentication
        : Optional[zio.aws.ec2.model.CertificateAuthentication.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mutualAuthentication())
        .map(value => zio.aws.ec2.model.CertificateAuthentication.wrap(value))
    override val federatedAuthentication
        : Optional[zio.aws.ec2.model.FederatedAuthentication.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.federatedAuthentication())
        .map(value => zio.aws.ec2.model.FederatedAuthentication.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ClientVpnAuthentication
  ): zio.aws.ec2.model.ClientVpnAuthentication.ReadOnly = new Wrapper(impl)
}
