package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TransitGatewayMulticastDeregisteredGroupSources(
    transitGatewayMulticastDomainId: Optional[String] = Optional.Absent,
    deregisteredNetworkInterfaceIds: Optional[Iterable[String]] =
      Optional.Absent,
    groupIpAddress: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TransitGatewayMulticastDeregisteredGroupSources = {
    import TransitGatewayMulticastDeregisteredGroupSources.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TransitGatewayMulticastDeregisteredGroupSources
      .builder()
      .optionallyWith(
        transitGatewayMulticastDomainId.map(value => value: java.lang.String)
      )(_.transitGatewayMulticastDomainId)
      .optionallyWith(
        deregisteredNetworkInterfaceIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.deregisteredNetworkInterfaceIds)
      .optionallyWith(groupIpAddress.map(value => value: java.lang.String))(
        _.groupIpAddress
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.TransitGatewayMulticastDeregisteredGroupSources.ReadOnly =
    zio.aws.ec2.model.TransitGatewayMulticastDeregisteredGroupSources
      .wrap(buildAwsValue())
}
object TransitGatewayMulticastDeregisteredGroupSources {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TransitGatewayMulticastDeregisteredGroupSources
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.TransitGatewayMulticastDeregisteredGroupSources =
      zio.aws.ec2.model.TransitGatewayMulticastDeregisteredGroupSources(
        transitGatewayMulticastDomainId.map(value => value),
        deregisteredNetworkInterfaceIds.map(value => value),
        groupIpAddress.map(value => value)
      )
    def transitGatewayMulticastDomainId: Optional[String]
    def deregisteredNetworkInterfaceIds: Optional[List[String]]
    def groupIpAddress: Optional[String]
    def getTransitGatewayMulticastDomainId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "transitGatewayMulticastDomainId",
        transitGatewayMulticastDomainId
      )
    def getDeregisteredNetworkInterfaceIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "deregisteredNetworkInterfaceIds",
        deregisteredNetworkInterfaceIds
      )
    def getGroupIpAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("groupIpAddress", groupIpAddress)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayMulticastDeregisteredGroupSources
  ) extends zio.aws.ec2.model.TransitGatewayMulticastDeregisteredGroupSources.ReadOnly {
    override val transitGatewayMulticastDomainId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transitGatewayMulticastDomainId())
        .map(value => value: String)
    override val deregisteredNetworkInterfaceIds: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deregisteredNetworkInterfaceIds())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val groupIpAddress: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.groupIpAddress())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayMulticastDeregisteredGroupSources
  ): zio.aws.ec2.model.TransitGatewayMulticastDeregisteredGroupSources.ReadOnly =
    new Wrapper(impl)
}
