package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait TransitGatewayAssociationState {
  def unwrap
      : software.amazon.awssdk.services.ec2.model.TransitGatewayAssociationState
}
object TransitGatewayAssociationState {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.TransitGatewayAssociationState
  ): zio.aws.ec2.model.TransitGatewayAssociationState = value match {
    case software.amazon.awssdk.services.ec2.model.TransitGatewayAssociationState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.TransitGatewayAssociationState.ASSOCIATING =>
      val r = associating
      r
    case software.amazon.awssdk.services.ec2.model.TransitGatewayAssociationState.ASSOCIATED =>
      val r = associated
      r
    case software.amazon.awssdk.services.ec2.model.TransitGatewayAssociationState.DISASSOCIATING =>
      val r = disassociating
      r
    case software.amazon.awssdk.services.ec2.model.TransitGatewayAssociationState.DISASSOCIATED =>
      val r = disassociated
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.TransitGatewayAssociationState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TransitGatewayAssociationState =
      software.amazon.awssdk.services.ec2.model.TransitGatewayAssociationState.UNKNOWN_TO_SDK_VERSION
  }
  case object associating
      extends zio.aws.ec2.model.TransitGatewayAssociationState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TransitGatewayAssociationState =
      software.amazon.awssdk.services.ec2.model.TransitGatewayAssociationState.ASSOCIATING
  }
  case object associated
      extends zio.aws.ec2.model.TransitGatewayAssociationState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TransitGatewayAssociationState =
      software.amazon.awssdk.services.ec2.model.TransitGatewayAssociationState.ASSOCIATED
  }
  case object disassociating
      extends zio.aws.ec2.model.TransitGatewayAssociationState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TransitGatewayAssociationState =
      software.amazon.awssdk.services.ec2.model.TransitGatewayAssociationState.DISASSOCIATING
  }
  case object disassociated
      extends zio.aws.ec2.model.TransitGatewayAssociationState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TransitGatewayAssociationState =
      software.amazon.awssdk.services.ec2.model.TransitGatewayAssociationState.DISASSOCIATED
  }
}
