package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TrafficMirrorTarget(
    trafficMirrorTargetId: Optional[String] = Optional.Absent,
    networkInterfaceId: Optional[String] = Optional.Absent,
    networkLoadBalancerArn: Optional[String] = Optional.Absent,
    `type`: Optional[zio.aws.ec2.model.TrafficMirrorTargetType] =
      Optional.Absent,
    description: Optional[String] = Optional.Absent,
    ownerId: Optional[String] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TrafficMirrorTarget = {
    import TrafficMirrorTarget.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TrafficMirrorTarget
      .builder()
      .optionallyWith(
        trafficMirrorTargetId.map(value => value: java.lang.String)
      )(_.trafficMirrorTargetId)
      .optionallyWith(networkInterfaceId.map(value => value: java.lang.String))(
        _.networkInterfaceId
      )
      .optionallyWith(
        networkLoadBalancerArn.map(value => value: java.lang.String)
      )(_.networkLoadBalancerArn)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.TrafficMirrorTarget.ReadOnly =
    zio.aws.ec2.model.TrafficMirrorTarget.wrap(buildAwsValue())
}
object TrafficMirrorTarget {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TrafficMirrorTarget
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TrafficMirrorTarget =
      zio.aws.ec2.model.TrafficMirrorTarget(
        trafficMirrorTargetId.map(value => value),
        networkInterfaceId.map(value => value),
        networkLoadBalancerArn.map(value => value),
        `type`.map(value => value),
        description.map(value => value),
        ownerId.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def trafficMirrorTargetId: Optional[String]
    def networkInterfaceId: Optional[String]
    def networkLoadBalancerArn: Optional[String]
    def `type`: Optional[zio.aws.ec2.model.TrafficMirrorTargetType]
    def description: Optional[String]
    def ownerId: Optional[String]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getTrafficMirrorTargetId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("trafficMirrorTargetId", trafficMirrorTargetId)
    def getNetworkInterfaceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("networkInterfaceId", networkInterfaceId)
    def getNetworkLoadBalancerArn: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("networkLoadBalancerArn", networkLoadBalancerArn)
    def getType: ZIO[Any, AwsError, zio.aws.ec2.model.TrafficMirrorTargetType] =
      AwsError.unwrapOptionField("type", `type`)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TrafficMirrorTarget
  ) extends zio.aws.ec2.model.TrafficMirrorTarget.ReadOnly {
    override val trafficMirrorTargetId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.trafficMirrorTargetId())
      .map(value => value: String)
    override val networkInterfaceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.networkInterfaceId())
      .map(value => value: String)
    override val networkLoadBalancerArn: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkLoadBalancerArn())
        .map(value => value: String)
    override val `type`: Optional[zio.aws.ec2.model.TrafficMirrorTargetType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.ec2.model.TrafficMirrorTargetType.wrap(value))
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val ownerId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerId())
      .map(value => value: String)
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TrafficMirrorTarget
  ): zio.aws.ec2.model.TrafficMirrorTarget.ReadOnly = new Wrapper(impl)
}
