package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.IpamPoolId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ProvisionIpamPoolCidrRequest(
    ipamPoolId: IpamPoolId,
    cidr: Optional[String] = Optional.Absent,
    cidrAuthorizationContext: Optional[
      zio.aws.ec2.model.IpamCidrAuthorizationContext
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ProvisionIpamPoolCidrRequest = {
    import ProvisionIpamPoolCidrRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ProvisionIpamPoolCidrRequest
      .builder()
      .ipamPoolId(IpamPoolId.unwrap(ipamPoolId): java.lang.String)
      .optionallyWith(cidr.map(value => value: java.lang.String))(_.cidr)
      .optionallyWith(
        cidrAuthorizationContext.map(value => value.buildAwsValue())
      )(_.cidrAuthorizationContext)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ProvisionIpamPoolCidrRequest.ReadOnly =
    zio.aws.ec2.model.ProvisionIpamPoolCidrRequest.wrap(buildAwsValue())
}
object ProvisionIpamPoolCidrRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ProvisionIpamPoolCidrRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ProvisionIpamPoolCidrRequest =
      zio.aws.ec2.model.ProvisionIpamPoolCidrRequest(
        ipamPoolId,
        cidr.map(value => value),
        cidrAuthorizationContext.map(value => value.asEditable)
      )
    def ipamPoolId: IpamPoolId
    def cidr: Optional[String]
    def cidrAuthorizationContext
        : Optional[zio.aws.ec2.model.IpamCidrAuthorizationContext.ReadOnly]
    def getIpamPoolId: ZIO[Any, Nothing, IpamPoolId] = ZIO.succeed(ipamPoolId)
    def getCidr: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cidr", cidr)
    def getCidrAuthorizationContext: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.IpamCidrAuthorizationContext.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cidrAuthorizationContext",
      cidrAuthorizationContext
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ProvisionIpamPoolCidrRequest
  ) extends zio.aws.ec2.model.ProvisionIpamPoolCidrRequest.ReadOnly {
    override val ipamPoolId: IpamPoolId =
      zio.aws.ec2.model.primitives.IpamPoolId(impl.ipamPoolId())
    override val cidr: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cidr())
      .map(value => value: String)
    override val cidrAuthorizationContext
        : Optional[zio.aws.ec2.model.IpamCidrAuthorizationContext.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cidrAuthorizationContext())
        .map(value =>
          zio.aws.ec2.model.IpamCidrAuthorizationContext.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ProvisionIpamPoolCidrRequest
  ): zio.aws.ec2.model.ProvisionIpamPoolCidrRequest.ReadOnly = new Wrapper(impl)
}
