package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PrivateDnsNameConfiguration(
    state: Optional[zio.aws.ec2.model.DnsNameState] = Optional.Absent,
    `type`: Optional[String] = Optional.Absent,
    value: Optional[String] = Optional.Absent,
    name: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.PrivateDnsNameConfiguration = {
    import PrivateDnsNameConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.PrivateDnsNameConfiguration
      .builder()
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(`type`.map(value => value: java.lang.String))(_.`type`)
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.PrivateDnsNameConfiguration.ReadOnly =
    zio.aws.ec2.model.PrivateDnsNameConfiguration.wrap(buildAwsValue())
}
object PrivateDnsNameConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.PrivateDnsNameConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.PrivateDnsNameConfiguration =
      zio.aws.ec2.model.PrivateDnsNameConfiguration(
        state.map(value => value),
        `type`.map(value => value),
        value.map(value => value),
        name.map(value => value)
      )
    def state: Optional[zio.aws.ec2.model.DnsNameState]
    def `type`: Optional[String]
    def value: Optional[String]
    def name: Optional[String]
    def getState: ZIO[Any, AwsError, zio.aws.ec2.model.DnsNameState] =
      AwsError.unwrapOptionField("state", state)
    def getType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("type", `type`)
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.PrivateDnsNameConfiguration
  ) extends zio.aws.ec2.model.PrivateDnsNameConfiguration.ReadOnly {
    override val state: Optional[zio.aws.ec2.model.DnsNameState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.ec2.model.DnsNameState.wrap(value))
    override val `type`: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value => value: String)
    override val value: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => value: String)
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.PrivateDnsNameConfiguration
  ): zio.aws.ec2.model.PrivateDnsNameConfiguration.ReadOnly = new Wrapper(impl)
}
