package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class OnDemandOptionsRequest(
    allocationStrategy: Optional[
      zio.aws.ec2.model.FleetOnDemandAllocationStrategy
    ] = Optional.Absent,
    capacityReservationOptions: Optional[
      zio.aws.ec2.model.CapacityReservationOptionsRequest
    ] = Optional.Absent,
    singleInstanceType: Optional[Boolean] = Optional.Absent,
    singleAvailabilityZone: Optional[Boolean] = Optional.Absent,
    minTargetCapacity: Optional[Integer] = Optional.Absent,
    maxTotalPrice: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.OnDemandOptionsRequest = {
    import OnDemandOptionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.OnDemandOptionsRequest
      .builder()
      .optionallyWith(allocationStrategy.map(value => value.unwrap))(
        _.allocationStrategy
      )
      .optionallyWith(
        capacityReservationOptions.map(value => value.buildAwsValue())
      )(_.capacityReservationOptions)
      .optionallyWith(
        singleInstanceType.map(value => value: java.lang.Boolean)
      )(_.singleInstanceType)
      .optionallyWith(
        singleAvailabilityZone.map(value => value: java.lang.Boolean)
      )(_.singleAvailabilityZone)
      .optionallyWith(minTargetCapacity.map(value => value: java.lang.Integer))(
        _.minTargetCapacity
      )
      .optionallyWith(maxTotalPrice.map(value => value: java.lang.String))(
        _.maxTotalPrice
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.OnDemandOptionsRequest.ReadOnly =
    zio.aws.ec2.model.OnDemandOptionsRequest.wrap(buildAwsValue())
}
object OnDemandOptionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.OnDemandOptionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.OnDemandOptionsRequest =
      zio.aws.ec2.model.OnDemandOptionsRequest(
        allocationStrategy.map(value => value),
        capacityReservationOptions.map(value => value.asEditable),
        singleInstanceType.map(value => value),
        singleAvailabilityZone.map(value => value),
        minTargetCapacity.map(value => value),
        maxTotalPrice.map(value => value)
      )
    def allocationStrategy
        : Optional[zio.aws.ec2.model.FleetOnDemandAllocationStrategy]
    def capacityReservationOptions
        : Optional[zio.aws.ec2.model.CapacityReservationOptionsRequest.ReadOnly]
    def singleInstanceType: Optional[Boolean]
    def singleAvailabilityZone: Optional[Boolean]
    def minTargetCapacity: Optional[Integer]
    def maxTotalPrice: Optional[String]
    def getAllocationStrategy: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.FleetOnDemandAllocationStrategy
    ] = AwsError.unwrapOptionField("allocationStrategy", allocationStrategy)
    def getCapacityReservationOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.CapacityReservationOptionsRequest.ReadOnly
    ] = AwsError.unwrapOptionField(
      "capacityReservationOptions",
      capacityReservationOptions
    )
    def getSingleInstanceType: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("singleInstanceType", singleInstanceType)
    def getSingleAvailabilityZone: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("singleAvailabilityZone", singleAvailabilityZone)
    def getMinTargetCapacity: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("minTargetCapacity", minTargetCapacity)
    def getMaxTotalPrice: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("maxTotalPrice", maxTotalPrice)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.OnDemandOptionsRequest
  ) extends zio.aws.ec2.model.OnDemandOptionsRequest.ReadOnly {
    override val allocationStrategy
        : Optional[zio.aws.ec2.model.FleetOnDemandAllocationStrategy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allocationStrategy())
        .map(value =>
          zio.aws.ec2.model.FleetOnDemandAllocationStrategy.wrap(value)
        )
    override val capacityReservationOptions: Optional[
      zio.aws.ec2.model.CapacityReservationOptionsRequest.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.capacityReservationOptions())
      .map(value =>
        zio.aws.ec2.model.CapacityReservationOptionsRequest.wrap(value)
      )
    override val singleInstanceType: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.singleInstanceType())
      .map(value => value: Boolean)
    override val singleAvailabilityZone: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.singleAvailabilityZone())
        .map(value => value: Boolean)
    override val minTargetCapacity: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.minTargetCapacity())
      .map(value => value: Integer)
    override val maxTotalPrice: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.maxTotalPrice())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.OnDemandOptionsRequest
  ): zio.aws.ec2.model.OnDemandOptionsRequest.ReadOnly = new Wrapper(impl)
}
