package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.VpcId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ModifyVpcTenancyRequest(
    vpcId: VpcId,
    instanceTenancy: zio.aws.ec2.model.VpcTenancy
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyVpcTenancyRequest = {
    import ModifyVpcTenancyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyVpcTenancyRequest
      .builder()
      .vpcId(VpcId.unwrap(vpcId): java.lang.String)
      .instanceTenancy(instanceTenancy.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifyVpcTenancyRequest.ReadOnly =
    zio.aws.ec2.model.ModifyVpcTenancyRequest.wrap(buildAwsValue())
}
object ModifyVpcTenancyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyVpcTenancyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyVpcTenancyRequest =
      zio.aws.ec2.model.ModifyVpcTenancyRequest(vpcId, instanceTenancy)
    def vpcId: VpcId
    def instanceTenancy: zio.aws.ec2.model.VpcTenancy
    def getVpcId: ZIO[Any, Nothing, VpcId] = ZIO.succeed(vpcId)
    def getInstanceTenancy: ZIO[Any, Nothing, zio.aws.ec2.model.VpcTenancy] =
      ZIO.succeed(instanceTenancy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVpcTenancyRequest
  ) extends zio.aws.ec2.model.ModifyVpcTenancyRequest.ReadOnly {
    override val vpcId: VpcId = zio.aws.ec2.model.primitives.VpcId(impl.vpcId())
    override val instanceTenancy: zio.aws.ec2.model.VpcTenancy =
      zio.aws.ec2.model.VpcTenancy.wrap(impl.instanceTenancy())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVpcTenancyRequest
  ): zio.aws.ec2.model.ModifyVpcTenancyRequest.ReadOnly = new Wrapper(impl)
}
