package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class KeyPairInfo(
    keyPairId: Optional[String] = Optional.Absent,
    keyFingerprint: Optional[String] = Optional.Absent,
    keyName: Optional[String] = Optional.Absent,
    keyType: Optional[zio.aws.ec2.model.KeyType] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.KeyPairInfo = {
    import KeyPairInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.KeyPairInfo
      .builder()
      .optionallyWith(keyPairId.map(value => value: java.lang.String))(
        _.keyPairId
      )
      .optionallyWith(keyFingerprint.map(value => value: java.lang.String))(
        _.keyFingerprint
      )
      .optionallyWith(keyName.map(value => value: java.lang.String))(_.keyName)
      .optionallyWith(keyType.map(value => value.unwrap))(_.keyType)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.KeyPairInfo.ReadOnly =
    zio.aws.ec2.model.KeyPairInfo.wrap(buildAwsValue())
}
object KeyPairInfo {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.KeyPairInfo] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.KeyPairInfo =
      zio.aws.ec2.model.KeyPairInfo(
        keyPairId.map(value => value),
        keyFingerprint.map(value => value),
        keyName.map(value => value),
        keyType.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def keyPairId: Optional[String]
    def keyFingerprint: Optional[String]
    def keyName: Optional[String]
    def keyType: Optional[zio.aws.ec2.model.KeyType]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getKeyPairId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("keyPairId", keyPairId)
    def getKeyFingerprint: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("keyFingerprint", keyFingerprint)
    def getKeyName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("keyName", keyName)
    def getKeyType: ZIO[Any, AwsError, zio.aws.ec2.model.KeyType] =
      AwsError.unwrapOptionField("keyType", keyType)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.KeyPairInfo
  ) extends zio.aws.ec2.model.KeyPairInfo.ReadOnly {
    override val keyPairId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.keyPairId())
      .map(value => value: String)
    override val keyFingerprint: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.keyFingerprint())
      .map(value => value: String)
    override val keyName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.keyName())
      .map(value => value: String)
    override val keyType: Optional[zio.aws.ec2.model.KeyType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keyType())
        .map(value => zio.aws.ec2.model.KeyType.wrap(value))
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.KeyPairInfo
  ): zio.aws.ec2.model.KeyPairInfo.ReadOnly = new Wrapper(impl)
}
