package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Ipv4PrefixSpecificationResponse(
    ipv4Prefix: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.Ipv4PrefixSpecificationResponse = {
    import Ipv4PrefixSpecificationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.Ipv4PrefixSpecificationResponse
      .builder()
      .optionallyWith(ipv4Prefix.map(value => value: java.lang.String))(
        _.ipv4Prefix
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.Ipv4PrefixSpecificationResponse.ReadOnly =
    zio.aws.ec2.model.Ipv4PrefixSpecificationResponse.wrap(buildAwsValue())
}
object Ipv4PrefixSpecificationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.Ipv4PrefixSpecificationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.Ipv4PrefixSpecificationResponse =
      zio.aws.ec2.model
        .Ipv4PrefixSpecificationResponse(ipv4Prefix.map(value => value))
    def ipv4Prefix: Optional[String]
    def getIpv4Prefix: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ipv4Prefix", ipv4Prefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.Ipv4PrefixSpecificationResponse
  ) extends zio.aws.ec2.model.Ipv4PrefixSpecificationResponse.ReadOnly {
    override val ipv4Prefix: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ipv4Prefix())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.Ipv4PrefixSpecificationResponse
  ): zio.aws.ec2.model.Ipv4PrefixSpecificationResponse.ReadOnly = new Wrapper(
    impl
  )
}
