package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait HostTenancy {
  def unwrap: software.amazon.awssdk.services.ec2.model.HostTenancy
}
object HostTenancy {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.HostTenancy
  ): zio.aws.ec2.model.HostTenancy = value match {
    case software.amazon.awssdk.services.ec2.model.HostTenancy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.HostTenancy.DEDICATED =>
      val r = dedicated
      r
    case software.amazon.awssdk.services.ec2.model.HostTenancy.HOST =>
      val r = host
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.HostTenancy {
    override def unwrap: software.amazon.awssdk.services.ec2.model.HostTenancy =
      software.amazon.awssdk.services.ec2.model.HostTenancy.UNKNOWN_TO_SDK_VERSION
  }
  case object dedicated extends zio.aws.ec2.model.HostTenancy {
    override def unwrap: software.amazon.awssdk.services.ec2.model.HostTenancy =
      software.amazon.awssdk.services.ec2.model.HostTenancy.DEDICATED
  }
  case object host extends zio.aws.ec2.model.HostTenancy {
    override def unwrap: software.amazon.awssdk.services.ec2.model.HostTenancy =
      software.amazon.awssdk.services.ec2.model.HostTenancy.HOST
  }
}
