package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait FastLaunchStateCode {
  def unwrap: software.amazon.awssdk.services.ec2.model.FastLaunchStateCode
}
object FastLaunchStateCode {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.FastLaunchStateCode
  ): zio.aws.ec2.model.FastLaunchStateCode = value match {
    case software.amazon.awssdk.services.ec2.model.FastLaunchStateCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.FastLaunchStateCode.ENABLING =>
      val r = enabling
      r
    case software.amazon.awssdk.services.ec2.model.FastLaunchStateCode.ENABLING_FAILED =>
      val r = `enabling-failed`
      r
    case software.amazon.awssdk.services.ec2.model.FastLaunchStateCode.ENABLED =>
      val r = enabled
      r
    case software.amazon.awssdk.services.ec2.model.FastLaunchStateCode.ENABLED_FAILED =>
      val r = `enabled-failed`
      r
    case software.amazon.awssdk.services.ec2.model.FastLaunchStateCode.DISABLING =>
      val r = disabling
      r
    case software.amazon.awssdk.services.ec2.model.FastLaunchStateCode.DISABLING_FAILED =>
      val r = `disabling-failed`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.FastLaunchStateCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.FastLaunchStateCode =
      software.amazon.awssdk.services.ec2.model.FastLaunchStateCode.UNKNOWN_TO_SDK_VERSION
  }
  case object enabling extends zio.aws.ec2.model.FastLaunchStateCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.FastLaunchStateCode =
      software.amazon.awssdk.services.ec2.model.FastLaunchStateCode.ENABLING
  }
  case object `enabling-failed` extends zio.aws.ec2.model.FastLaunchStateCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.FastLaunchStateCode =
      software.amazon.awssdk.services.ec2.model.FastLaunchStateCode.ENABLING_FAILED
  }
  case object enabled extends zio.aws.ec2.model.FastLaunchStateCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.FastLaunchStateCode =
      software.amazon.awssdk.services.ec2.model.FastLaunchStateCode.ENABLED
  }
  case object `enabled-failed` extends zio.aws.ec2.model.FastLaunchStateCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.FastLaunchStateCode =
      software.amazon.awssdk.services.ec2.model.FastLaunchStateCode.ENABLED_FAILED
  }
  case object disabling extends zio.aws.ec2.model.FastLaunchStateCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.FastLaunchStateCode =
      software.amazon.awssdk.services.ec2.model.FastLaunchStateCode.DISABLING
  }
  case object `disabling-failed` extends zio.aws.ec2.model.FastLaunchStateCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.FastLaunchStateCode =
      software.amazon.awssdk.services.ec2.model.FastLaunchStateCode.DISABLING_FAILED
  }
}
