package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait ExcessCapacityTerminationPolicy {
  def unwrap: software.amazon.awssdk.services.ec2.model.ExcessCapacityTerminationPolicy
}
object ExcessCapacityTerminationPolicy {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.ExcessCapacityTerminationPolicy
  ): zio.aws.ec2.model.ExcessCapacityTerminationPolicy = value match {
    case software.amazon.awssdk.services.ec2.model.ExcessCapacityTerminationPolicy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.ExcessCapacityTerminationPolicy.NO_TERMINATION =>
      val r = noTermination
      r
    case software.amazon.awssdk.services.ec2.model.ExcessCapacityTerminationPolicy.DEFAULT =>
      val r = default
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.ExcessCapacityTerminationPolicy {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ExcessCapacityTerminationPolicy =
      software.amazon.awssdk.services.ec2.model.ExcessCapacityTerminationPolicy.UNKNOWN_TO_SDK_VERSION
  }
  case object noTermination
      extends zio.aws.ec2.model.ExcessCapacityTerminationPolicy {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ExcessCapacityTerminationPolicy =
      software.amazon.awssdk.services.ec2.model.ExcessCapacityTerminationPolicy.NO_TERMINATION
  }
  case object default
      extends zio.aws.ec2.model.ExcessCapacityTerminationPolicy {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ExcessCapacityTerminationPolicy =
      software.amazon.awssdk.services.ec2.model.ExcessCapacityTerminationPolicy.DEFAULT
  }
}
