package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.DateTime
import scala.jdk.CollectionConverters._
final case class ElasticInferenceAcceleratorAssociation(
    elasticInferenceAcceleratorArn: Optional[String] = Optional.Absent,
    elasticInferenceAcceleratorAssociationId: Optional[String] =
      Optional.Absent,
    elasticInferenceAcceleratorAssociationState: Optional[String] =
      Optional.Absent,
    elasticInferenceAcceleratorAssociationTime: Optional[DateTime] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ElasticInferenceAcceleratorAssociation = {
    import ElasticInferenceAcceleratorAssociation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ElasticInferenceAcceleratorAssociation
      .builder()
      .optionallyWith(
        elasticInferenceAcceleratorArn.map(value => value: java.lang.String)
      )(_.elasticInferenceAcceleratorArn)
      .optionallyWith(
        elasticInferenceAcceleratorAssociationId.map(value =>
          value: java.lang.String
        )
      )(_.elasticInferenceAcceleratorAssociationId)
      .optionallyWith(
        elasticInferenceAcceleratorAssociationState.map(value =>
          value: java.lang.String
        )
      )(_.elasticInferenceAcceleratorAssociationState)
      .optionallyWith(
        elasticInferenceAcceleratorAssociationTime.map(value =>
          DateTime.unwrap(value): Instant
        )
      )(_.elasticInferenceAcceleratorAssociationTime)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ElasticInferenceAcceleratorAssociation.ReadOnly =
    zio.aws.ec2.model.ElasticInferenceAcceleratorAssociation
      .wrap(buildAwsValue())
}
object ElasticInferenceAcceleratorAssociation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ElasticInferenceAcceleratorAssociation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ElasticInferenceAcceleratorAssociation =
      zio.aws.ec2.model.ElasticInferenceAcceleratorAssociation(
        elasticInferenceAcceleratorArn.map(value => value),
        elasticInferenceAcceleratorAssociationId.map(value => value),
        elasticInferenceAcceleratorAssociationState.map(value => value),
        elasticInferenceAcceleratorAssociationTime.map(value => value)
      )
    def elasticInferenceAcceleratorArn: Optional[String]
    def elasticInferenceAcceleratorAssociationId: Optional[String]
    def elasticInferenceAcceleratorAssociationState: Optional[String]
    def elasticInferenceAcceleratorAssociationTime: Optional[DateTime]
    def getElasticInferenceAcceleratorArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "elasticInferenceAcceleratorArn",
        elasticInferenceAcceleratorArn
      )
    def getElasticInferenceAcceleratorAssociationId
        : ZIO[Any, AwsError, String] = AwsError.unwrapOptionField(
      "elasticInferenceAcceleratorAssociationId",
      elasticInferenceAcceleratorAssociationId
    )
    def getElasticInferenceAcceleratorAssociationState
        : ZIO[Any, AwsError, String] = AwsError.unwrapOptionField(
      "elasticInferenceAcceleratorAssociationState",
      elasticInferenceAcceleratorAssociationState
    )
    def getElasticInferenceAcceleratorAssociationTime
        : ZIO[Any, AwsError, DateTime] = AwsError.unwrapOptionField(
      "elasticInferenceAcceleratorAssociationTime",
      elasticInferenceAcceleratorAssociationTime
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ElasticInferenceAcceleratorAssociation
  ) extends zio.aws.ec2.model.ElasticInferenceAcceleratorAssociation.ReadOnly {
    override val elasticInferenceAcceleratorArn: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.elasticInferenceAcceleratorArn())
        .map(value => value: String)
    override val elasticInferenceAcceleratorAssociationId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.elasticInferenceAcceleratorAssociationId())
        .map(value => value: String)
    override val elasticInferenceAcceleratorAssociationState
        : Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.elasticInferenceAcceleratorAssociationState())
      .map(value => value: String)
    override val elasticInferenceAcceleratorAssociationTime
        : Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.elasticInferenceAcceleratorAssociationTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ElasticInferenceAcceleratorAssociation
  ): zio.aws.ec2.model.ElasticInferenceAcceleratorAssociation.ReadOnly =
    new Wrapper(impl)
}
