package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  DescribeVpcPeeringConnectionsMaxResults,
  VpcPeeringConnectionId
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeVpcPeeringConnectionsRequest(
    filters: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent,
    vpcPeeringConnectionIds: Optional[Iterable[VpcPeeringConnectionId]] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[DescribeVpcPeeringConnectionsMaxResults] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeVpcPeeringConnectionsRequest = {
    import DescribeVpcPeeringConnectionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeVpcPeeringConnectionsRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        vpcPeeringConnectionIds.map(value =>
          value.map { item =>
            VpcPeeringConnectionId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.vpcPeeringConnectionIds)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value =>
          DescribeVpcPeeringConnectionsMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeVpcPeeringConnectionsRequest.ReadOnly =
    zio.aws.ec2.model.DescribeVpcPeeringConnectionsRequest.wrap(buildAwsValue())
}
object DescribeVpcPeeringConnectionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeVpcPeeringConnectionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeVpcPeeringConnectionsRequest =
      zio.aws.ec2.model.DescribeVpcPeeringConnectionsRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        vpcPeeringConnectionIds.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def vpcPeeringConnectionIds: Optional[List[VpcPeeringConnectionId]]
    def nextToken: Optional[String]
    def maxResults: Optional[DescribeVpcPeeringConnectionsMaxResults]
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getVpcPeeringConnectionIds
        : ZIO[Any, AwsError, List[VpcPeeringConnectionId]] = AwsError
      .unwrapOptionField("vpcPeeringConnectionIds", vpcPeeringConnectionIds)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults
        : ZIO[Any, AwsError, DescribeVpcPeeringConnectionsMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVpcPeeringConnectionsRequest
  ) extends zio.aws.ec2.model.DescribeVpcPeeringConnectionsRequest.ReadOnly {
    override val filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val vpcPeeringConnectionIds
        : Optional[List[VpcPeeringConnectionId]] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcPeeringConnectionIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.VpcPeeringConnectionId(item)
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[DescribeVpcPeeringConnectionsMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.ec2.model.primitives
            .DescribeVpcPeeringConnectionsMaxResults(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVpcPeeringConnectionsRequest
  ): zio.aws.ec2.model.DescribeVpcPeeringConnectionsRequest.ReadOnly =
    new Wrapper(impl)
}
