package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{NextToken, PrefixListMaxResults}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeManagedPrefixListsRequest(
    filters: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent,
    maxResults: Optional[PrefixListMaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    prefixListIds: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeManagedPrefixListsRequest = {
    import DescribeManagedPrefixListsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeManagedPrefixListsRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value => PrefixListMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        prefixListIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.prefixListIds)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeManagedPrefixListsRequest.ReadOnly =
    zio.aws.ec2.model.DescribeManagedPrefixListsRequest.wrap(buildAwsValue())
}
object DescribeManagedPrefixListsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeManagedPrefixListsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeManagedPrefixListsRequest =
      zio.aws.ec2.model.DescribeManagedPrefixListsRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value),
        prefixListIds.map(value => value)
      )
    def filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def maxResults: Optional[PrefixListMaxResults]
    def nextToken: Optional[NextToken]
    def prefixListIds: Optional[List[String]]
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, PrefixListMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getPrefixListIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("prefixListIds", prefixListIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeManagedPrefixListsRequest
  ) extends zio.aws.ec2.model.DescribeManagedPrefixListsRequest.ReadOnly {
    override val filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val maxResults: Optional[PrefixListMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value => zio.aws.ec2.model.primitives.PrefixListMaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
    override val prefixListIds: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.prefixListIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeManagedPrefixListsRequest
  ): zio.aws.ec2.model.DescribeManagedPrefixListsRequest.ReadOnly = new Wrapper(
    impl
  )
}
