package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  LocalGatewayMaxResults,
  LocalGatewayVirtualInterfaceGroupId
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeLocalGatewayVirtualInterfaceGroupsRequest(
    localGatewayVirtualInterfaceGroupIds: Optional[
      Iterable[LocalGatewayVirtualInterfaceGroupId]
    ] = Optional.Absent,
    filters: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent,
    maxResults: Optional[LocalGatewayMaxResults] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayVirtualInterfaceGroupsRequest = {
    import DescribeLocalGatewayVirtualInterfaceGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayVirtualInterfaceGroupsRequest
      .builder()
      .optionallyWith(
        localGatewayVirtualInterfaceGroupIds.map(value =>
          value.map { item =>
            LocalGatewayVirtualInterfaceGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.localGatewayVirtualInterfaceGroupIds)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value => LocalGatewayMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeLocalGatewayVirtualInterfaceGroupsRequest.ReadOnly =
    zio.aws.ec2.model.DescribeLocalGatewayVirtualInterfaceGroupsRequest
      .wrap(buildAwsValue())
}
object DescribeLocalGatewayVirtualInterfaceGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayVirtualInterfaceGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DescribeLocalGatewayVirtualInterfaceGroupsRequest =
      zio.aws.ec2.model.DescribeLocalGatewayVirtualInterfaceGroupsRequest(
        localGatewayVirtualInterfaceGroupIds.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def localGatewayVirtualInterfaceGroupIds
        : Optional[List[LocalGatewayVirtualInterfaceGroupId]]
    def filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def maxResults: Optional[LocalGatewayMaxResults]
    def nextToken: Optional[String]
    def getLocalGatewayVirtualInterfaceGroupIds
        : ZIO[Any, AwsError, List[LocalGatewayVirtualInterfaceGroupId]] =
      AwsError.unwrapOptionField(
        "localGatewayVirtualInterfaceGroupIds",
        localGatewayVirtualInterfaceGroupIds
      )
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, LocalGatewayMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayVirtualInterfaceGroupsRequest
  ) extends zio.aws.ec2.model.DescribeLocalGatewayVirtualInterfaceGroupsRequest.ReadOnly {
    override val localGatewayVirtualInterfaceGroupIds
        : Optional[List[LocalGatewayVirtualInterfaceGroupId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.localGatewayVirtualInterfaceGroupIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives
              .LocalGatewayVirtualInterfaceGroupId(item)
          }.toList
        )
    override val filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val maxResults: Optional[LocalGatewayMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.ec2.model.primitives.LocalGatewayMaxResults(value)
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayVirtualInterfaceGroupsRequest
  ): zio.aws.ec2.model.DescribeLocalGatewayVirtualInterfaceGroupsRequest.ReadOnly =
    new Wrapper(impl)
}
