package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeHostsResponse(
    hosts: Optional[Iterable[zio.aws.ec2.model.Host]] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeHostsResponse = {
    import DescribeHostsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeHostsResponse
      .builder()
      .optionallyWith(
        hosts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.hosts)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeHostsResponse.ReadOnly =
    zio.aws.ec2.model.DescribeHostsResponse.wrap(buildAwsValue())
}
object DescribeHostsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeHostsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeHostsResponse =
      zio.aws.ec2.model.DescribeHostsResponse(
        hosts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def hosts: Optional[List[zio.aws.ec2.model.Host.ReadOnly]]
    def nextToken: Optional[String]
    def getHosts: ZIO[Any, AwsError, List[zio.aws.ec2.model.Host.ReadOnly]] =
      AwsError.unwrapOptionField("hosts", hosts)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeHostsResponse
  ) extends zio.aws.ec2.model.DescribeHostsResponse.ReadOnly {
    override val hosts: Optional[List[zio.aws.ec2.model.Host.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hosts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Host.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeHostsResponse
  ): zio.aws.ec2.model.DescribeHostsResponse.ReadOnly = new Wrapper(impl)
}
