package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.IpamPoolId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteIpamPoolRequest(ipamPoolId: IpamPoolId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteIpamPoolRequest = {
    import DeleteIpamPoolRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteIpamPoolRequest
      .builder()
      .ipamPoolId(IpamPoolId.unwrap(ipamPoolId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteIpamPoolRequest.ReadOnly =
    zio.aws.ec2.model.DeleteIpamPoolRequest.wrap(buildAwsValue())
}
object DeleteIpamPoolRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteIpamPoolRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteIpamPoolRequest =
      zio.aws.ec2.model.DeleteIpamPoolRequest(ipamPoolId)
    def ipamPoolId: IpamPoolId
    def getIpamPoolId: ZIO[Any, Nothing, IpamPoolId] = ZIO.succeed(ipamPoolId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteIpamPoolRequest
  ) extends zio.aws.ec2.model.DeleteIpamPoolRequest.ReadOnly {
    override val ipamPoolId: IpamPoolId =
      zio.aws.ec2.model.primitives.IpamPoolId(impl.ipamPoolId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteIpamPoolRequest
  ): zio.aws.ec2.model.DeleteIpamPoolRequest.ReadOnly = new Wrapper(impl)
}
