package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateSnapshotsRequest(
    description: Optional[String] = Optional.Absent,
    instanceSpecification: zio.aws.ec2.model.InstanceSpecification,
    outpostArn: Optional[String] = Optional.Absent,
    tagSpecifications: Optional[Iterable[zio.aws.ec2.model.TagSpecification]] =
      Optional.Absent,
    copyTagsFromSource: Optional[zio.aws.ec2.model.CopyTagsFromSource] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateSnapshotsRequest = {
    import CreateSnapshotsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateSnapshotsRequest
      .builder()
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .instanceSpecification(instanceSpecification.buildAwsValue())
      .optionallyWith(outpostArn.map(value => value: java.lang.String))(
        _.outpostArn
      )
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .optionallyWith(copyTagsFromSource.map(value => value.unwrap))(
        _.copyTagsFromSource
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateSnapshotsRequest.ReadOnly =
    zio.aws.ec2.model.CreateSnapshotsRequest.wrap(buildAwsValue())
}
object CreateSnapshotsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateSnapshotsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateSnapshotsRequest =
      zio.aws.ec2.model.CreateSnapshotsRequest(
        description.map(value => value),
        instanceSpecification.asEditable,
        outpostArn.map(value => value),
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        copyTagsFromSource.map(value => value)
      )
    def description: Optional[String]
    def instanceSpecification: zio.aws.ec2.model.InstanceSpecification.ReadOnly
    def outpostArn: Optional[String]
    def tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def copyTagsFromSource: Optional[zio.aws.ec2.model.CopyTagsFromSource]
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getInstanceSpecification
        : ZIO[Any, Nothing, zio.aws.ec2.model.InstanceSpecification.ReadOnly] =
      ZIO.succeed(instanceSpecification)
    def getOutpostArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("outpostArn", outpostArn)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
    def getCopyTagsFromSource
        : ZIO[Any, AwsError, zio.aws.ec2.model.CopyTagsFromSource] =
      AwsError.unwrapOptionField("copyTagsFromSource", copyTagsFromSource)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateSnapshotsRequest
  ) extends zio.aws.ec2.model.CreateSnapshotsRequest.ReadOnly {
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val instanceSpecification
        : zio.aws.ec2.model.InstanceSpecification.ReadOnly =
      zio.aws.ec2.model.InstanceSpecification.wrap(impl.instanceSpecification())
    override val outpostArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.outpostArn())
      .map(value => value: String)
    override val tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagSpecifications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TagSpecification.wrap(item)
          }.toList
        )
    override val copyTagsFromSource
        : Optional[zio.aws.ec2.model.CopyTagsFromSource] = zio.aws.core.internal
      .optionalFromNullable(impl.copyTagsFromSource())
      .map(value => zio.aws.ec2.model.CopyTagsFromSource.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateSnapshotsRequest
  ): zio.aws.ec2.model.CreateSnapshotsRequest.ReadOnly = new Wrapper(impl)
}
