package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{SubnetId, Integer, SecurityGroupId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateNetworkInterfaceRequest(
    description: Optional[String] = Optional.Absent,
    groups: Optional[Iterable[SecurityGroupId]] = Optional.Absent,
    ipv6AddressCount: Optional[Integer] = Optional.Absent,
    ipv6Addresses: Optional[Iterable[zio.aws.ec2.model.InstanceIpv6Address]] =
      Optional.Absent,
    privateIpAddress: Optional[String] = Optional.Absent,
    privateIpAddresses: Optional[
      Iterable[zio.aws.ec2.model.PrivateIpAddressSpecification]
    ] = Optional.Absent,
    secondaryPrivateIpAddressCount: Optional[Integer] = Optional.Absent,
    ipv4Prefixes: Optional[
      Iterable[zio.aws.ec2.model.Ipv4PrefixSpecificationRequest]
    ] = Optional.Absent,
    ipv4PrefixCount: Optional[Integer] = Optional.Absent,
    ipv6Prefixes: Optional[
      Iterable[zio.aws.ec2.model.Ipv6PrefixSpecificationRequest]
    ] = Optional.Absent,
    ipv6PrefixCount: Optional[Integer] = Optional.Absent,
    interfaceType: Optional[zio.aws.ec2.model.NetworkInterfaceCreationType] =
      Optional.Absent,
    subnetId: SubnetId,
    tagSpecifications: Optional[Iterable[zio.aws.ec2.model.TagSpecification]] =
      Optional.Absent,
    clientToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateNetworkInterfaceRequest = {
    import CreateNetworkInterfaceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateNetworkInterfaceRequest
      .builder()
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        groups.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.groups)
      .optionallyWith(ipv6AddressCount.map(value => value: java.lang.Integer))(
        _.ipv6AddressCount
      )
      .optionallyWith(
        ipv6Addresses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipv6Addresses)
      .optionallyWith(privateIpAddress.map(value => value: java.lang.String))(
        _.privateIpAddress
      )
      .optionallyWith(
        privateIpAddresses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.privateIpAddresses)
      .optionallyWith(
        secondaryPrivateIpAddressCount.map(value => value: java.lang.Integer)
      )(_.secondaryPrivateIpAddressCount)
      .optionallyWith(
        ipv4Prefixes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipv4Prefixes)
      .optionallyWith(ipv4PrefixCount.map(value => value: java.lang.Integer))(
        _.ipv4PrefixCount
      )
      .optionallyWith(
        ipv6Prefixes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipv6Prefixes)
      .optionallyWith(ipv6PrefixCount.map(value => value: java.lang.Integer))(
        _.ipv6PrefixCount
      )
      .optionallyWith(interfaceType.map(value => value.unwrap))(_.interfaceType)
      .subnetId(SubnetId.unwrap(subnetId): java.lang.String)
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateNetworkInterfaceRequest.ReadOnly =
    zio.aws.ec2.model.CreateNetworkInterfaceRequest.wrap(buildAwsValue())
}
object CreateNetworkInterfaceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateNetworkInterfaceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateNetworkInterfaceRequest =
      zio.aws.ec2.model.CreateNetworkInterfaceRequest(
        description.map(value => value),
        groups.map(value => value),
        ipv6AddressCount.map(value => value),
        ipv6Addresses.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        privateIpAddress.map(value => value),
        privateIpAddresses.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        secondaryPrivateIpAddressCount.map(value => value),
        ipv4Prefixes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ipv4PrefixCount.map(value => value),
        ipv6Prefixes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ipv6PrefixCount.map(value => value),
        interfaceType.map(value => value),
        subnetId,
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clientToken.map(value => value)
      )
    def description: Optional[String]
    def groups: Optional[List[SecurityGroupId]]
    def ipv6AddressCount: Optional[Integer]
    def ipv6Addresses
        : Optional[List[zio.aws.ec2.model.InstanceIpv6Address.ReadOnly]]
    def privateIpAddress: Optional[String]
    def privateIpAddresses: Optional[
      List[zio.aws.ec2.model.PrivateIpAddressSpecification.ReadOnly]
    ]
    def secondaryPrivateIpAddressCount: Optional[Integer]
    def ipv4Prefixes: Optional[
      List[zio.aws.ec2.model.Ipv4PrefixSpecificationRequest.ReadOnly]
    ]
    def ipv4PrefixCount: Optional[Integer]
    def ipv6Prefixes: Optional[
      List[zio.aws.ec2.model.Ipv6PrefixSpecificationRequest.ReadOnly]
    ]
    def ipv6PrefixCount: Optional[Integer]
    def interfaceType: Optional[zio.aws.ec2.model.NetworkInterfaceCreationType]
    def subnetId: SubnetId
    def tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def clientToken: Optional[String]
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getGroups: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("groups", groups)
    def getIpv6AddressCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("ipv6AddressCount", ipv6AddressCount)
    def getIpv6Addresses: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.InstanceIpv6Address.ReadOnly
    ]] = AwsError.unwrapOptionField("ipv6Addresses", ipv6Addresses)
    def getPrivateIpAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("privateIpAddress", privateIpAddress)
    def getPrivateIpAddresses: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.PrivateIpAddressSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("privateIpAddresses", privateIpAddresses)
    def getSecondaryPrivateIpAddressCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "secondaryPrivateIpAddressCount",
        secondaryPrivateIpAddressCount
      )
    def getIpv4Prefixes: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.Ipv4PrefixSpecificationRequest.ReadOnly
    ]] = AwsError.unwrapOptionField("ipv4Prefixes", ipv4Prefixes)
    def getIpv4PrefixCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("ipv4PrefixCount", ipv4PrefixCount)
    def getIpv6Prefixes: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.Ipv6PrefixSpecificationRequest.ReadOnly
    ]] = AwsError.unwrapOptionField("ipv6Prefixes", ipv6Prefixes)
    def getIpv6PrefixCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("ipv6PrefixCount", ipv6PrefixCount)
    def getInterfaceType
        : ZIO[Any, AwsError, zio.aws.ec2.model.NetworkInterfaceCreationType] =
      AwsError.unwrapOptionField("interfaceType", interfaceType)
    def getSubnetId: ZIO[Any, Nothing, SubnetId] = ZIO.succeed(subnetId)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateNetworkInterfaceRequest
  ) extends zio.aws.ec2.model.CreateNetworkInterfaceRequest.ReadOnly {
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val groups: Optional[List[SecurityGroupId]] = zio.aws.core.internal
      .optionalFromNullable(impl.groups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.SecurityGroupId(item)
        }.toList
      )
    override val ipv6AddressCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.ipv6AddressCount())
      .map(value => value: Integer)
    override val ipv6Addresses
        : Optional[List[zio.aws.ec2.model.InstanceIpv6Address.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipv6Addresses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.InstanceIpv6Address.wrap(item)
          }.toList
        )
    override val privateIpAddress: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.privateIpAddress())
      .map(value => value: String)
    override val privateIpAddresses: Optional[
      List[zio.aws.ec2.model.PrivateIpAddressSpecification.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.privateIpAddresses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.PrivateIpAddressSpecification.wrap(item)
        }.toList
      )
    override val secondaryPrivateIpAddressCount: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.secondaryPrivateIpAddressCount())
        .map(value => value: Integer)
    override val ipv4Prefixes: Optional[
      List[zio.aws.ec2.model.Ipv4PrefixSpecificationRequest.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.ipv4Prefixes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Ipv4PrefixSpecificationRequest.wrap(item)
        }.toList
      )
    override val ipv4PrefixCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.ipv4PrefixCount())
      .map(value => value: Integer)
    override val ipv6Prefixes: Optional[
      List[zio.aws.ec2.model.Ipv6PrefixSpecificationRequest.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.ipv6Prefixes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Ipv6PrefixSpecificationRequest.wrap(item)
        }.toList
      )
    override val ipv6PrefixCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.ipv6PrefixCount())
      .map(value => value: Integer)
    override val interfaceType
        : Optional[zio.aws.ec2.model.NetworkInterfaceCreationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.interfaceType())
        .map(value =>
          zio.aws.ec2.model.NetworkInterfaceCreationType.wrap(value)
        )
    override val subnetId: SubnetId =
      zio.aws.ec2.model.primitives.SubnetId(impl.subnetId())
    override val tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagSpecifications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TagSpecification.wrap(item)
          }.toList
        )
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateNetworkInterfaceRequest
  ): zio.aws.ec2.model.CreateNetworkInterfaceRequest.ReadOnly = new Wrapper(
    impl
  )
}
