package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait BareMetal {
  def unwrap: software.amazon.awssdk.services.ec2.model.BareMetal
}
object BareMetal {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.BareMetal
  ): zio.aws.ec2.model.BareMetal = value match {
    case software.amazon.awssdk.services.ec2.model.BareMetal.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.BareMetal.INCLUDED =>
      val r = included
      r
    case software.amazon.awssdk.services.ec2.model.BareMetal.REQUIRED =>
      val r = required
      r
    case software.amazon.awssdk.services.ec2.model.BareMetal.EXCLUDED =>
      val r = excluded
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.BareMetal {
    override def unwrap: software.amazon.awssdk.services.ec2.model.BareMetal =
      software.amazon.awssdk.services.ec2.model.BareMetal.UNKNOWN_TO_SDK_VERSION
  }
  case object included extends zio.aws.ec2.model.BareMetal {
    override def unwrap: software.amazon.awssdk.services.ec2.model.BareMetal =
      software.amazon.awssdk.services.ec2.model.BareMetal.INCLUDED
  }
  case object required extends zio.aws.ec2.model.BareMetal {
    override def unwrap: software.amazon.awssdk.services.ec2.model.BareMetal =
      software.amazon.awssdk.services.ec2.model.BareMetal.REQUIRED
  }
  case object excluded extends zio.aws.ec2.model.BareMetal {
    override def unwrap: software.amazon.awssdk.services.ec2.model.BareMetal =
      software.amazon.awssdk.services.ec2.model.BareMetal.EXCLUDED
  }
}
