package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.MillisecondDateTime
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class VpcEndpoint(
    vpcEndpointId: Option[String] = None,
    vpcEndpointType: Option[zio.aws.ec2.model.VpcEndpointType] = None,
    vpcId: Option[String] = None,
    serviceName: Option[String] = None,
    state: Option[zio.aws.ec2.model.State] = None,
    policyDocument: Option[String] = None,
    routeTableIds: Option[Iterable[String]] = None,
    subnetIds: Option[Iterable[String]] = None,
    groups: Option[Iterable[zio.aws.ec2.model.SecurityGroupIdentifier]] = None,
    privateDnsEnabled: Option[Boolean] = None,
    requesterManaged: Option[Boolean] = None,
    networkInterfaceIds: Option[Iterable[String]] = None,
    dnsEntries: Option[Iterable[zio.aws.ec2.model.DnsEntry]] = None,
    creationTimestamp: Option[MillisecondDateTime] = None,
    tags: Option[Iterable[zio.aws.ec2.model.Tag]] = None,
    ownerId: Option[String] = None,
    lastError: Option[zio.aws.ec2.model.LastError] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.VpcEndpoint = {
    import VpcEndpoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.VpcEndpoint
      .builder()
      .optionallyWith(vpcEndpointId.map(value => value: java.lang.String))(
        _.vpcEndpointId
      )
      .optionallyWith(vpcEndpointType.map(value => value.unwrap))(
        _.vpcEndpointType
      )
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(serviceName.map(value => value: java.lang.String))(
        _.serviceName
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(policyDocument.map(value => value: java.lang.String))(
        _.policyDocument
      )
      .optionallyWith(
        routeTableIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.routeTableIds)
      .optionallyWith(
        subnetIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.subnetIds)
      .optionallyWith(
        groups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.groups)
      .optionallyWith(privateDnsEnabled.map(value => value: java.lang.Boolean))(
        _.privateDnsEnabled
      )
      .optionallyWith(requesterManaged.map(value => value: java.lang.Boolean))(
        _.requesterManaged
      )
      .optionallyWith(
        networkInterfaceIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.networkInterfaceIds)
      .optionallyWith(
        dnsEntries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dnsEntries)
      .optionallyWith(
        creationTimestamp.map(value =>
          MillisecondDateTime.unwrap(value): Instant
        )
      )(_.creationTimestamp)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .optionallyWith(lastError.map(value => value.buildAwsValue()))(
        _.lastError
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.VpcEndpoint.ReadOnly =
    zio.aws.ec2.model.VpcEndpoint.wrap(buildAwsValue())
}
object VpcEndpoint {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.VpcEndpoint] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.VpcEndpoint =
      zio.aws.ec2.model.VpcEndpoint(
        vpcEndpointId.map(value => value),
        vpcEndpointType.map(value => value),
        vpcId.map(value => value),
        serviceName.map(value => value),
        state.map(value => value),
        policyDocument.map(value => value),
        routeTableIds.map(value => value),
        subnetIds.map(value => value),
        groups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        privateDnsEnabled.map(value => value),
        requesterManaged.map(value => value),
        networkInterfaceIds.map(value => value),
        dnsEntries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        creationTimestamp.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ownerId.map(value => value),
        lastError.map(value => value.asEditable)
      )
    def vpcEndpointId: Option[String]
    def vpcEndpointType: Option[zio.aws.ec2.model.VpcEndpointType]
    def vpcId: Option[String]
    def serviceName: Option[String]
    def state: Option[zio.aws.ec2.model.State]
    def policyDocument: Option[String]
    def routeTableIds: Option[List[String]]
    def subnetIds: Option[List[String]]
    def groups: Option[List[zio.aws.ec2.model.SecurityGroupIdentifier.ReadOnly]]
    def privateDnsEnabled: Option[Boolean]
    def requesterManaged: Option[Boolean]
    def networkInterfaceIds: Option[List[String]]
    def dnsEntries: Option[List[zio.aws.ec2.model.DnsEntry.ReadOnly]]
    def creationTimestamp: Option[MillisecondDateTime]
    def tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def ownerId: Option[String]
    def lastError: Option[zio.aws.ec2.model.LastError.ReadOnly]
    def getVpcEndpointId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcEndpointId", vpcEndpointId)
    def getVpcEndpointType
        : ZIO[Any, AwsError, zio.aws.ec2.model.VpcEndpointType] =
      AwsError.unwrapOptionField("vpcEndpointType", vpcEndpointType)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getServiceName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceName", serviceName)
    def getState: ZIO[Any, AwsError, zio.aws.ec2.model.State] =
      AwsError.unwrapOptionField("state", state)
    def getPolicyDocument: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("policyDocument", policyDocument)
    def getRouteTableIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("routeTableIds", routeTableIds)
    def getSubnetIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("subnetIds", subnetIds)
    def getGroups: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.SecurityGroupIdentifier.ReadOnly
    ]] = AwsError.unwrapOptionField("groups", groups)
    def getPrivateDnsEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("privateDnsEnabled", privateDnsEnabled)
    def getRequesterManaged: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("requesterManaged", requesterManaged)
    def getNetworkInterfaceIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("networkInterfaceIds", networkInterfaceIds)
    def getDnsEntries
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.DnsEntry.ReadOnly]] =
      AwsError.unwrapOptionField("dnsEntries", dnsEntries)
    def getCreationTimestamp: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("creationTimestamp", creationTimestamp)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getLastError: ZIO[Any, AwsError, zio.aws.ec2.model.LastError.ReadOnly] =
      AwsError.unwrapOptionField("lastError", lastError)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.VpcEndpoint
  ) extends zio.aws.ec2.model.VpcEndpoint.ReadOnly {
    override val vpcEndpointId: Option[String] =
      scala.Option(impl.vpcEndpointId()).map(value => value: String)
    override val vpcEndpointType: Option[zio.aws.ec2.model.VpcEndpointType] =
      scala
        .Option(impl.vpcEndpointType())
        .map(value => zio.aws.ec2.model.VpcEndpointType.wrap(value))
    override val vpcId: Option[String] =
      scala.Option(impl.vpcId()).map(value => value: String)
    override val serviceName: Option[String] =
      scala.Option(impl.serviceName()).map(value => value: String)
    override val state: Option[zio.aws.ec2.model.State] = scala
      .Option(impl.state())
      .map(value => zio.aws.ec2.model.State.wrap(value))
    override val policyDocument: Option[String] =
      scala.Option(impl.policyDocument()).map(value => value: String)
    override val routeTableIds: Option[List[String]] = scala
      .Option(impl.routeTableIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val subnetIds: Option[List[String]] = scala
      .Option(impl.subnetIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val groups
        : Option[List[zio.aws.ec2.model.SecurityGroupIdentifier.ReadOnly]] =
      scala
        .Option(impl.groups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.SecurityGroupIdentifier.wrap(item)
          }.toList
        )
    override val privateDnsEnabled: Option[Boolean] =
      scala.Option(impl.privateDnsEnabled()).map(value => value: Boolean)
    override val requesterManaged: Option[Boolean] =
      scala.Option(impl.requesterManaged()).map(value => value: Boolean)
    override val networkInterfaceIds: Option[List[String]] = scala
      .Option(impl.networkInterfaceIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val dnsEntries: Option[List[zio.aws.ec2.model.DnsEntry.ReadOnly]] =
      scala
        .Option(impl.dnsEntries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.DnsEntry.wrap(item)
          }.toList
        )
    override val creationTimestamp: Option[MillisecondDateTime] = scala
      .Option(impl.creationTimestamp())
      .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Tag.wrap(item)
        }.toList
      )
    override val ownerId: Option[String] =
      scala.Option(impl.ownerId()).map(value => value: String)
    override val lastError: Option[zio.aws.ec2.model.LastError.ReadOnly] = scala
      .Option(impl.lastError())
      .map(value => zio.aws.ec2.model.LastError.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.VpcEndpoint
  ): zio.aws.ec2.model.VpcEndpoint.ReadOnly = new Wrapper(impl)
}
