package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{Integer, DateTime}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class Volume(
    attachments: Option[Iterable[zio.aws.ec2.model.VolumeAttachment]] = None,
    availabilityZone: Option[String] = None,
    createTime: Option[DateTime] = None,
    encrypted: Option[Boolean] = None,
    kmsKeyId: Option[String] = None,
    outpostArn: Option[String] = None,
    size: Option[Integer] = None,
    snapshotId: Option[String] = None,
    state: Option[zio.aws.ec2.model.VolumeState] = None,
    volumeId: Option[String] = None,
    iops: Option[Integer] = None,
    tags: Option[Iterable[zio.aws.ec2.model.Tag]] = None,
    volumeType: Option[zio.aws.ec2.model.VolumeType] = None,
    fastRestored: Option[Boolean] = None,
    multiAttachEnabled: Option[Boolean] = None,
    throughput: Option[Integer] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.Volume = {
    import Volume.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.Volume
      .builder()
      .optionallyWith(
        attachments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attachments)
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(createTime.map(value => DateTime.unwrap(value): Instant))(
        _.createTime
      )
      .optionallyWith(encrypted.map(value => value: java.lang.Boolean))(
        _.encrypted
      )
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(outpostArn.map(value => value: java.lang.String))(
        _.outpostArn
      )
      .optionallyWith(size.map(value => value: java.lang.Integer))(_.size)
      .optionallyWith(snapshotId.map(value => value: java.lang.String))(
        _.snapshotId
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(volumeId.map(value => value: java.lang.String))(
        _.volumeId
      )
      .optionallyWith(iops.map(value => value: java.lang.Integer))(_.iops)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(volumeType.map(value => value.unwrap))(_.volumeType)
      .optionallyWith(fastRestored.map(value => value: java.lang.Boolean))(
        _.fastRestored
      )
      .optionallyWith(
        multiAttachEnabled.map(value => value: java.lang.Boolean)
      )(_.multiAttachEnabled)
      .optionallyWith(throughput.map(value => value: java.lang.Integer))(
        _.throughput
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.Volume.ReadOnly =
    zio.aws.ec2.model.Volume.wrap(buildAwsValue())
}
object Volume {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.Volume] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.Volume = zio.aws.ec2.model.Volume(
      attachments.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      availabilityZone.map(value => value),
      createTime.map(value => value),
      encrypted.map(value => value),
      kmsKeyId.map(value => value),
      outpostArn.map(value => value),
      size.map(value => value),
      snapshotId.map(value => value),
      state.map(value => value),
      volumeId.map(value => value),
      iops.map(value => value),
      tags.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      volumeType.map(value => value),
      fastRestored.map(value => value),
      multiAttachEnabled.map(value => value),
      throughput.map(value => value)
    )
    def attachments: Option[List[zio.aws.ec2.model.VolumeAttachment.ReadOnly]]
    def availabilityZone: Option[String]
    def createTime: Option[DateTime]
    def encrypted: Option[Boolean]
    def kmsKeyId: Option[String]
    def outpostArn: Option[String]
    def size: Option[Integer]
    def snapshotId: Option[String]
    def state: Option[zio.aws.ec2.model.VolumeState]
    def volumeId: Option[String]
    def iops: Option[Integer]
    def tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def volumeType: Option[zio.aws.ec2.model.VolumeType]
    def fastRestored: Option[Boolean]
    def multiAttachEnabled: Option[Boolean]
    def throughput: Option[Integer]
    def getAttachments: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.VolumeAttachment.ReadOnly
    ]] = AwsError.unwrapOptionField("attachments", attachments)
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getCreateTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("createTime", createTime)
    def getEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("encrypted", encrypted)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getOutpostArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("outpostArn", outpostArn)
    def getSize: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("size", size)
    def getSnapshotId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotId", snapshotId)
    def getState: ZIO[Any, AwsError, zio.aws.ec2.model.VolumeState] =
      AwsError.unwrapOptionField("state", state)
    def getVolumeId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("volumeId", volumeId)
    def getIops: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("iops", iops)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getVolumeType: ZIO[Any, AwsError, zio.aws.ec2.model.VolumeType] =
      AwsError.unwrapOptionField("volumeType", volumeType)
    def getFastRestored: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("fastRestored", fastRestored)
    def getMultiAttachEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("multiAttachEnabled", multiAttachEnabled)
    def getThroughput: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("throughput", throughput)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.Volume
  ) extends zio.aws.ec2.model.Volume.ReadOnly {
    override val attachments
        : Option[List[zio.aws.ec2.model.VolumeAttachment.ReadOnly]] = scala
      .Option(impl.attachments())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.VolumeAttachment.wrap(item)
        }.toList
      )
    override val availabilityZone: Option[String] =
      scala.Option(impl.availabilityZone()).map(value => value: String)
    override val createTime: Option[DateTime] = scala
      .Option(impl.createTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val encrypted: Option[Boolean] =
      scala.Option(impl.encrypted()).map(value => value: Boolean)
    override val kmsKeyId: Option[String] =
      scala.Option(impl.kmsKeyId()).map(value => value: String)
    override val outpostArn: Option[String] =
      scala.Option(impl.outpostArn()).map(value => value: String)
    override val size: Option[Integer] =
      scala.Option(impl.size()).map(value => value: Integer)
    override val snapshotId: Option[String] =
      scala.Option(impl.snapshotId()).map(value => value: String)
    override val state: Option[zio.aws.ec2.model.VolumeState] = scala
      .Option(impl.state())
      .map(value => zio.aws.ec2.model.VolumeState.wrap(value))
    override val volumeId: Option[String] =
      scala.Option(impl.volumeId()).map(value => value: String)
    override val iops: Option[Integer] =
      scala.Option(impl.iops()).map(value => value: Integer)
    override val tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Tag.wrap(item)
        }.toList
      )
    override val volumeType: Option[zio.aws.ec2.model.VolumeType] = scala
      .Option(impl.volumeType())
      .map(value => zio.aws.ec2.model.VolumeType.wrap(value))
    override val fastRestored: Option[Boolean] =
      scala.Option(impl.fastRestored()).map(value => value: Boolean)
    override val multiAttachEnabled: Option[Boolean] =
      scala.Option(impl.multiAttachEnabled()).map(value => value: Boolean)
    override val throughput: Option[Integer] =
      scala.Option(impl.throughput()).map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.Volume
  ): zio.aws.ec2.model.Volume.ReadOnly = new Wrapper(impl)
}
