package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{Integer, MillisecondDateTime}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class StoreImageTaskResult(
    amiId: Option[String] = None,
    taskStartTime: Option[MillisecondDateTime] = None,
    bucket: Option[String] = None,
    s3objectKey: Option[String] = None,
    progressPercentage: Option[Integer] = None,
    storeTaskState: Option[String] = None,
    storeTaskFailureReason: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.StoreImageTaskResult = {
    import StoreImageTaskResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.StoreImageTaskResult
      .builder()
      .optionallyWith(amiId.map(value => value: java.lang.String))(_.amiId)
      .optionallyWith(
        taskStartTime.map(value => MillisecondDateTime.unwrap(value): Instant)
      )(_.taskStartTime)
      .optionallyWith(bucket.map(value => value: java.lang.String))(_.bucket)
      .optionallyWith(s3objectKey.map(value => value: java.lang.String))(
        _.s3objectKey
      )
      .optionallyWith(
        progressPercentage.map(value => value: java.lang.Integer)
      )(_.progressPercentage)
      .optionallyWith(storeTaskState.map(value => value: java.lang.String))(
        _.storeTaskState
      )
      .optionallyWith(
        storeTaskFailureReason.map(value => value: java.lang.String)
      )(_.storeTaskFailureReason)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.StoreImageTaskResult.ReadOnly =
    zio.aws.ec2.model.StoreImageTaskResult.wrap(buildAwsValue())
}
object StoreImageTaskResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.StoreImageTaskResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.StoreImageTaskResult =
      zio.aws.ec2.model.StoreImageTaskResult(
        amiId.map(value => value),
        taskStartTime.map(value => value),
        bucket.map(value => value),
        s3objectKey.map(value => value),
        progressPercentage.map(value => value),
        storeTaskState.map(value => value),
        storeTaskFailureReason.map(value => value)
      )
    def amiId: Option[String]
    def taskStartTime: Option[MillisecondDateTime]
    def bucket: Option[String]
    def s3objectKey: Option[String]
    def progressPercentage: Option[Integer]
    def storeTaskState: Option[String]
    def storeTaskFailureReason: Option[String]
    def getAmiId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("amiId", amiId)
    def getTaskStartTime: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("taskStartTime", taskStartTime)
    def getBucket: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("bucket", bucket)
    def getS3objectKey: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("s3objectKey", s3objectKey)
    def getProgressPercentage: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("progressPercentage", progressPercentage)
    def getStoreTaskState: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("storeTaskState", storeTaskState)
    def getStoreTaskFailureReason: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("storeTaskFailureReason", storeTaskFailureReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.StoreImageTaskResult
  ) extends zio.aws.ec2.model.StoreImageTaskResult.ReadOnly {
    override val amiId: Option[String] =
      scala.Option(impl.amiId()).map(value => value: String)
    override val taskStartTime: Option[MillisecondDateTime] = scala
      .Option(impl.taskStartTime())
      .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val bucket: Option[String] =
      scala.Option(impl.bucket()).map(value => value: String)
    override val s3objectKey: Option[String] =
      scala.Option(impl.s3objectKey()).map(value => value: String)
    override val progressPercentage: Option[Integer] =
      scala.Option(impl.progressPercentage()).map(value => value: Integer)
    override val storeTaskState: Option[String] =
      scala.Option(impl.storeTaskState()).map(value => value: String)
    override val storeTaskFailureReason: Option[String] =
      scala.Option(impl.storeTaskFailureReason()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.StoreImageTaskResult
  ): zio.aws.ec2.model.StoreImageTaskResult.ReadOnly = new Wrapper(impl)
}
