package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  SubnetId,
  KeyPairName,
  SecurityGroupId,
  Integer,
  KernelId,
  SecurityGroupName,
  ImageId,
  RamdiskId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RunInstancesRequest(
    blockDeviceMappings: Option[
      Iterable[zio.aws.ec2.model.BlockDeviceMapping]
    ] = None,
    imageId: Option[ImageId] = None,
    instanceType: Option[zio.aws.ec2.model.InstanceType] = None,
    ipv6AddressCount: Option[Integer] = None,
    ipv6Addresses: Option[Iterable[zio.aws.ec2.model.InstanceIpv6Address]] =
      None,
    kernelId: Option[KernelId] = None,
    keyName: Option[KeyPairName] = None,
    maxCount: Integer,
    minCount: Integer,
    monitoring: Option[zio.aws.ec2.model.RunInstancesMonitoringEnabled] = None,
    placement: Option[zio.aws.ec2.model.Placement] = None,
    ramdiskId: Option[RamdiskId] = None,
    securityGroupIds: Option[Iterable[SecurityGroupId]] = None,
    securityGroups: Option[Iterable[SecurityGroupName]] = None,
    subnetId: Option[SubnetId] = None,
    userData: Option[String] = None,
    additionalInfo: Option[String] = None,
    clientToken: Option[String] = None,
    disableApiTermination: Option[Boolean] = None,
    ebsOptimized: Option[Boolean] = None,
    iamInstanceProfile: Option[
      zio.aws.ec2.model.IamInstanceProfileSpecification
    ] = None,
    instanceInitiatedShutdownBehavior: Option[
      zio.aws.ec2.model.ShutdownBehavior
    ] = None,
    networkInterfaces: Option[
      Iterable[zio.aws.ec2.model.InstanceNetworkInterfaceSpecification]
    ] = None,
    privateIpAddress: Option[String] = None,
    elasticGpuSpecification: Option[
      Iterable[zio.aws.ec2.model.ElasticGpuSpecification]
    ] = None,
    elasticInferenceAccelerators: Option[
      Iterable[zio.aws.ec2.model.ElasticInferenceAccelerator]
    ] = None,
    tagSpecifications: Option[Iterable[zio.aws.ec2.model.TagSpecification]] =
      None,
    launchTemplate: Option[zio.aws.ec2.model.LaunchTemplateSpecification] =
      None,
    instanceMarketOptions: Option[
      zio.aws.ec2.model.InstanceMarketOptionsRequest
    ] = None,
    creditSpecification: Option[zio.aws.ec2.model.CreditSpecificationRequest] =
      None,
    cpuOptions: Option[zio.aws.ec2.model.CpuOptionsRequest] = None,
    capacityReservationSpecification: Option[
      zio.aws.ec2.model.CapacityReservationSpecification
    ] = None,
    hibernationOptions: Option[zio.aws.ec2.model.HibernationOptionsRequest] =
      None,
    licenseSpecifications: Option[
      Iterable[zio.aws.ec2.model.LicenseConfigurationRequest]
    ] = None,
    metadataOptions: Option[zio.aws.ec2.model.InstanceMetadataOptionsRequest] =
      None,
    enclaveOptions: Option[zio.aws.ec2.model.EnclaveOptionsRequest] = None,
    privateDnsNameOptions: Option[
      zio.aws.ec2.model.PrivateDnsNameOptionsRequest
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.RunInstancesRequest = {
    import RunInstancesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.RunInstancesRequest
      .builder()
      .optionallyWith(
        blockDeviceMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.blockDeviceMappings)
      .optionallyWith(
        imageId.map(value => ImageId.unwrap(value): java.lang.String)
      )(_.imageId)
      .optionallyWith(instanceType.map(value => value.unwrap))(_.instanceType)
      .optionallyWith(ipv6AddressCount.map(value => value: java.lang.Integer))(
        _.ipv6AddressCount
      )
      .optionallyWith(
        ipv6Addresses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipv6Addresses)
      .optionallyWith(
        kernelId.map(value => KernelId.unwrap(value): java.lang.String)
      )(_.kernelId)
      .optionallyWith(
        keyName.map(value => KeyPairName.unwrap(value): java.lang.String)
      )(_.keyName)
      .maxCount(maxCount: java.lang.Integer)
      .minCount(minCount: java.lang.Integer)
      .optionallyWith(monitoring.map(value => value.buildAwsValue()))(
        _.monitoring
      )
      .optionallyWith(placement.map(value => value.buildAwsValue()))(
        _.placement
      )
      .optionallyWith(
        ramdiskId.map(value => RamdiskId.unwrap(value): java.lang.String)
      )(_.ramdiskId)
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(
        securityGroups.map(value =>
          value.map { item =>
            SecurityGroupName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroups)
      .optionallyWith(
        subnetId.map(value => SubnetId.unwrap(value): java.lang.String)
      )(_.subnetId)
      .optionallyWith(userData.map(value => value: java.lang.String))(
        _.userData
      )
      .optionallyWith(additionalInfo.map(value => value: java.lang.String))(
        _.additionalInfo
      )
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(
        disableApiTermination.map(value => value: java.lang.Boolean)
      )(_.disableApiTermination)
      .optionallyWith(ebsOptimized.map(value => value: java.lang.Boolean))(
        _.ebsOptimized
      )
      .optionallyWith(iamInstanceProfile.map(value => value.buildAwsValue()))(
        _.iamInstanceProfile
      )
      .optionallyWith(
        instanceInitiatedShutdownBehavior.map(value => value.unwrap)
      )(_.instanceInitiatedShutdownBehavior)
      .optionallyWith(
        networkInterfaces.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkInterfaces)
      .optionallyWith(privateIpAddress.map(value => value: java.lang.String))(
        _.privateIpAddress
      )
      .optionallyWith(
        elasticGpuSpecification.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.elasticGpuSpecification)
      .optionallyWith(
        elasticInferenceAccelerators.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.elasticInferenceAccelerators)
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .optionallyWith(launchTemplate.map(value => value.buildAwsValue()))(
        _.launchTemplate
      )
      .optionallyWith(
        instanceMarketOptions.map(value => value.buildAwsValue())
      )(_.instanceMarketOptions)
      .optionallyWith(creditSpecification.map(value => value.buildAwsValue()))(
        _.creditSpecification
      )
      .optionallyWith(cpuOptions.map(value => value.buildAwsValue()))(
        _.cpuOptions
      )
      .optionallyWith(
        capacityReservationSpecification.map(value => value.buildAwsValue())
      )(_.capacityReservationSpecification)
      .optionallyWith(hibernationOptions.map(value => value.buildAwsValue()))(
        _.hibernationOptions
      )
      .optionallyWith(
        licenseSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.licenseSpecifications)
      .optionallyWith(metadataOptions.map(value => value.buildAwsValue()))(
        _.metadataOptions
      )
      .optionallyWith(enclaveOptions.map(value => value.buildAwsValue()))(
        _.enclaveOptions
      )
      .optionallyWith(
        privateDnsNameOptions.map(value => value.buildAwsValue())
      )(_.privateDnsNameOptions)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.RunInstancesRequest.ReadOnly =
    zio.aws.ec2.model.RunInstancesRequest.wrap(buildAwsValue())
}
object RunInstancesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.RunInstancesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.RunInstancesRequest =
      zio.aws.ec2.model.RunInstancesRequest(
        blockDeviceMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        imageId.map(value => value),
        instanceType.map(value => value),
        ipv6AddressCount.map(value => value),
        ipv6Addresses.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        kernelId.map(value => value),
        keyName.map(value => value),
        maxCount,
        minCount,
        monitoring.map(value => value.asEditable),
        placement.map(value => value.asEditable),
        ramdiskId.map(value => value),
        securityGroupIds.map(value => value),
        securityGroups.map(value => value),
        subnetId.map(value => value),
        userData.map(value => value),
        additionalInfo.map(value => value),
        clientToken.map(value => value),
        disableApiTermination.map(value => value),
        ebsOptimized.map(value => value),
        iamInstanceProfile.map(value => value.asEditable),
        instanceInitiatedShutdownBehavior.map(value => value),
        networkInterfaces.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        privateIpAddress.map(value => value),
        elasticGpuSpecification.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        elasticInferenceAccelerators.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        launchTemplate.map(value => value.asEditable),
        instanceMarketOptions.map(value => value.asEditable),
        creditSpecification.map(value => value.asEditable),
        cpuOptions.map(value => value.asEditable),
        capacityReservationSpecification.map(value => value.asEditable),
        hibernationOptions.map(value => value.asEditable),
        licenseSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        metadataOptions.map(value => value.asEditable),
        enclaveOptions.map(value => value.asEditable),
        privateDnsNameOptions.map(value => value.asEditable)
      )
    def blockDeviceMappings
        : Option[List[zio.aws.ec2.model.BlockDeviceMapping.ReadOnly]]
    def imageId: Option[ImageId]
    def instanceType: Option[zio.aws.ec2.model.InstanceType]
    def ipv6AddressCount: Option[Integer]
    def ipv6Addresses
        : Option[List[zio.aws.ec2.model.InstanceIpv6Address.ReadOnly]]
    def kernelId: Option[KernelId]
    def keyName: Option[KeyPairName]
    def maxCount: Integer
    def minCount: Integer
    def monitoring
        : Option[zio.aws.ec2.model.RunInstancesMonitoringEnabled.ReadOnly]
    def placement: Option[zio.aws.ec2.model.Placement.ReadOnly]
    def ramdiskId: Option[RamdiskId]
    def securityGroupIds: Option[List[SecurityGroupId]]
    def securityGroups: Option[List[SecurityGroupName]]
    def subnetId: Option[SubnetId]
    def userData: Option[String]
    def additionalInfo: Option[String]
    def clientToken: Option[String]
    def disableApiTermination: Option[Boolean]
    def ebsOptimized: Option[Boolean]
    def iamInstanceProfile
        : Option[zio.aws.ec2.model.IamInstanceProfileSpecification.ReadOnly]
    def instanceInitiatedShutdownBehavior
        : Option[zio.aws.ec2.model.ShutdownBehavior]
    def networkInterfaces: Option[
      List[zio.aws.ec2.model.InstanceNetworkInterfaceSpecification.ReadOnly]
    ]
    def privateIpAddress: Option[String]
    def elasticGpuSpecification
        : Option[List[zio.aws.ec2.model.ElasticGpuSpecification.ReadOnly]]
    def elasticInferenceAccelerators
        : Option[List[zio.aws.ec2.model.ElasticInferenceAccelerator.ReadOnly]]
    def tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def launchTemplate
        : Option[zio.aws.ec2.model.LaunchTemplateSpecification.ReadOnly]
    def instanceMarketOptions
        : Option[zio.aws.ec2.model.InstanceMarketOptionsRequest.ReadOnly]
    def creditSpecification
        : Option[zio.aws.ec2.model.CreditSpecificationRequest.ReadOnly]
    def cpuOptions: Option[zio.aws.ec2.model.CpuOptionsRequest.ReadOnly]
    def capacityReservationSpecification
        : Option[zio.aws.ec2.model.CapacityReservationSpecification.ReadOnly]
    def hibernationOptions
        : Option[zio.aws.ec2.model.HibernationOptionsRequest.ReadOnly]
    def licenseSpecifications
        : Option[List[zio.aws.ec2.model.LicenseConfigurationRequest.ReadOnly]]
    def metadataOptions
        : Option[zio.aws.ec2.model.InstanceMetadataOptionsRequest.ReadOnly]
    def enclaveOptions: Option[zio.aws.ec2.model.EnclaveOptionsRequest.ReadOnly]
    def privateDnsNameOptions
        : Option[zio.aws.ec2.model.PrivateDnsNameOptionsRequest.ReadOnly]
    def getBlockDeviceMappings: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.BlockDeviceMapping.ReadOnly
    ]] = AwsError.unwrapOptionField("blockDeviceMappings", blockDeviceMappings)
    def getImageId: ZIO[Any, AwsError, ImageId] =
      AwsError.unwrapOptionField("imageId", imageId)
    def getInstanceType: ZIO[Any, AwsError, zio.aws.ec2.model.InstanceType] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getIpv6AddressCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("ipv6AddressCount", ipv6AddressCount)
    def getIpv6Addresses: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.InstanceIpv6Address.ReadOnly
    ]] = AwsError.unwrapOptionField("ipv6Addresses", ipv6Addresses)
    def getKernelId: ZIO[Any, AwsError, KernelId] =
      AwsError.unwrapOptionField("kernelId", kernelId)
    def getKeyName: ZIO[Any, AwsError, KeyPairName] =
      AwsError.unwrapOptionField("keyName", keyName)
    def getMaxCount: ZIO[Any, Nothing, Integer] = ZIO.succeed(maxCount)
    def getMinCount: ZIO[Any, Nothing, Integer] = ZIO.succeed(minCount)
    def getMonitoring: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.RunInstancesMonitoringEnabled.ReadOnly
    ] = AwsError.unwrapOptionField("monitoring", monitoring)
    def getPlacement: ZIO[Any, AwsError, zio.aws.ec2.model.Placement.ReadOnly] =
      AwsError.unwrapOptionField("placement", placement)
    def getRamdiskId: ZIO[Any, AwsError, RamdiskId] =
      AwsError.unwrapOptionField("ramdiskId", ramdiskId)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getSecurityGroups: ZIO[Any, AwsError, List[SecurityGroupName]] =
      AwsError.unwrapOptionField("securityGroups", securityGroups)
    def getSubnetId: ZIO[Any, AwsError, SubnetId] =
      AwsError.unwrapOptionField("subnetId", subnetId)
    def getUserData: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("userData", userData)
    def getAdditionalInfo: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("additionalInfo", additionalInfo)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDisableApiTermination: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("disableApiTermination", disableApiTermination)
    def getEbsOptimized: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("ebsOptimized", ebsOptimized)
    def getIamInstanceProfile: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.IamInstanceProfileSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("iamInstanceProfile", iamInstanceProfile)
    def getInstanceInitiatedShutdownBehavior
        : ZIO[Any, AwsError, zio.aws.ec2.model.ShutdownBehavior] =
      AwsError.unwrapOptionField(
        "instanceInitiatedShutdownBehavior",
        instanceInitiatedShutdownBehavior
      )
    def getNetworkInterfaces: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.InstanceNetworkInterfaceSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("networkInterfaces", networkInterfaces)
    def getPrivateIpAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("privateIpAddress", privateIpAddress)
    def getElasticGpuSpecification: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.ElasticGpuSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "elasticGpuSpecification",
      elasticGpuSpecification
    )
    def getElasticInferenceAccelerators: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.ElasticInferenceAccelerator.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "elasticInferenceAccelerators",
      elasticInferenceAccelerators
    )
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
    def getLaunchTemplate: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.LaunchTemplateSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("launchTemplate", launchTemplate)
    def getInstanceMarketOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.InstanceMarketOptionsRequest.ReadOnly
    ] =
      AwsError.unwrapOptionField("instanceMarketOptions", instanceMarketOptions)
    def getCreditSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.CreditSpecificationRequest.ReadOnly
    ] = AwsError.unwrapOptionField("creditSpecification", creditSpecification)
    def getCpuOptions
        : ZIO[Any, AwsError, zio.aws.ec2.model.CpuOptionsRequest.ReadOnly] =
      AwsError.unwrapOptionField("cpuOptions", cpuOptions)
    def getCapacityReservationSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.CapacityReservationSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "capacityReservationSpecification",
      capacityReservationSpecification
    )
    def getHibernationOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.HibernationOptionsRequest.ReadOnly
    ] = AwsError.unwrapOptionField("hibernationOptions", hibernationOptions)
    def getLicenseSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.LicenseConfigurationRequest.ReadOnly
    ]] =
      AwsError.unwrapOptionField("licenseSpecifications", licenseSpecifications)
    def getMetadataOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.InstanceMetadataOptionsRequest.ReadOnly
    ] = AwsError.unwrapOptionField("metadataOptions", metadataOptions)
    def getEnclaveOptions
        : ZIO[Any, AwsError, zio.aws.ec2.model.EnclaveOptionsRequest.ReadOnly] =
      AwsError.unwrapOptionField("enclaveOptions", enclaveOptions)
    def getPrivateDnsNameOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.PrivateDnsNameOptionsRequest.ReadOnly
    ] =
      AwsError.unwrapOptionField("privateDnsNameOptions", privateDnsNameOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.RunInstancesRequest
  ) extends zio.aws.ec2.model.RunInstancesRequest.ReadOnly {
    override val blockDeviceMappings
        : Option[List[zio.aws.ec2.model.BlockDeviceMapping.ReadOnly]] = scala
      .Option(impl.blockDeviceMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.BlockDeviceMapping.wrap(item)
        }.toList
      )
    override val imageId: Option[ImageId] = scala
      .Option(impl.imageId())
      .map(value => zio.aws.ec2.model.primitives.ImageId(value))
    override val instanceType: Option[zio.aws.ec2.model.InstanceType] = scala
      .Option(impl.instanceType())
      .map(value => zio.aws.ec2.model.InstanceType.wrap(value))
    override val ipv6AddressCount: Option[Integer] =
      scala.Option(impl.ipv6AddressCount()).map(value => value: Integer)
    override val ipv6Addresses
        : Option[List[zio.aws.ec2.model.InstanceIpv6Address.ReadOnly]] = scala
      .Option(impl.ipv6Addresses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.InstanceIpv6Address.wrap(item)
        }.toList
      )
    override val kernelId: Option[KernelId] = scala
      .Option(impl.kernelId())
      .map(value => zio.aws.ec2.model.primitives.KernelId(value))
    override val keyName: Option[KeyPairName] = scala
      .Option(impl.keyName())
      .map(value => zio.aws.ec2.model.primitives.KeyPairName(value))
    override val maxCount: Integer = impl.maxCount(): Integer
    override val minCount: Integer = impl.minCount(): Integer
    override val monitoring
        : Option[zio.aws.ec2.model.RunInstancesMonitoringEnabled.ReadOnly] =
      scala
        .Option(impl.monitoring())
        .map(value =>
          zio.aws.ec2.model.RunInstancesMonitoringEnabled.wrap(value)
        )
    override val placement: Option[zio.aws.ec2.model.Placement.ReadOnly] = scala
      .Option(impl.placement())
      .map(value => zio.aws.ec2.model.Placement.wrap(value))
    override val ramdiskId: Option[RamdiskId] = scala
      .Option(impl.ramdiskId())
      .map(value => zio.aws.ec2.model.primitives.RamdiskId(value))
    override val securityGroupIds: Option[List[SecurityGroupId]] = scala
      .Option(impl.securityGroupIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.SecurityGroupId(item)
        }.toList
      )
    override val securityGroups: Option[List[SecurityGroupName]] = scala
      .Option(impl.securityGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.SecurityGroupName(item)
        }.toList
      )
    override val subnetId: Option[SubnetId] = scala
      .Option(impl.subnetId())
      .map(value => zio.aws.ec2.model.primitives.SubnetId(value))
    override val userData: Option[String] =
      scala.Option(impl.userData()).map(value => value: String)
    override val additionalInfo: Option[String] =
      scala.Option(impl.additionalInfo()).map(value => value: String)
    override val clientToken: Option[String] =
      scala.Option(impl.clientToken()).map(value => value: String)
    override val disableApiTermination: Option[Boolean] =
      scala.Option(impl.disableApiTermination()).map(value => value: Boolean)
    override val ebsOptimized: Option[Boolean] =
      scala.Option(impl.ebsOptimized()).map(value => value: Boolean)
    override val iamInstanceProfile
        : Option[zio.aws.ec2.model.IamInstanceProfileSpecification.ReadOnly] =
      scala
        .Option(impl.iamInstanceProfile())
        .map(value =>
          zio.aws.ec2.model.IamInstanceProfileSpecification.wrap(value)
        )
    override val instanceInitiatedShutdownBehavior
        : Option[zio.aws.ec2.model.ShutdownBehavior] = scala
      .Option(impl.instanceInitiatedShutdownBehavior())
      .map(value => zio.aws.ec2.model.ShutdownBehavior.wrap(value))
    override val networkInterfaces: Option[
      List[zio.aws.ec2.model.InstanceNetworkInterfaceSpecification.ReadOnly]
    ] = scala
      .Option(impl.networkInterfaces())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.InstanceNetworkInterfaceSpecification.wrap(item)
        }.toList
      )
    override val privateIpAddress: Option[String] =
      scala.Option(impl.privateIpAddress()).map(value => value: String)
    override val elasticGpuSpecification
        : Option[List[zio.aws.ec2.model.ElasticGpuSpecification.ReadOnly]] =
      scala
        .Option(impl.elasticGpuSpecification())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.ElasticGpuSpecification.wrap(item)
          }.toList
        )
    override val elasticInferenceAccelerators
        : Option[List[zio.aws.ec2.model.ElasticInferenceAccelerator.ReadOnly]] =
      scala
        .Option(impl.elasticInferenceAccelerators())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.ElasticInferenceAccelerator.wrap(item)
          }.toList
        )
    override val tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] = scala
      .Option(impl.tagSpecifications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.TagSpecification.wrap(item)
        }.toList
      )
    override val launchTemplate
        : Option[zio.aws.ec2.model.LaunchTemplateSpecification.ReadOnly] = scala
      .Option(impl.launchTemplate())
      .map(value => zio.aws.ec2.model.LaunchTemplateSpecification.wrap(value))
    override val instanceMarketOptions
        : Option[zio.aws.ec2.model.InstanceMarketOptionsRequest.ReadOnly] =
      scala
        .Option(impl.instanceMarketOptions())
        .map(value =>
          zio.aws.ec2.model.InstanceMarketOptionsRequest.wrap(value)
        )
    override val creditSpecification
        : Option[zio.aws.ec2.model.CreditSpecificationRequest.ReadOnly] = scala
      .Option(impl.creditSpecification())
      .map(value => zio.aws.ec2.model.CreditSpecificationRequest.wrap(value))
    override val cpuOptions
        : Option[zio.aws.ec2.model.CpuOptionsRequest.ReadOnly] = scala
      .Option(impl.cpuOptions())
      .map(value => zio.aws.ec2.model.CpuOptionsRequest.wrap(value))
    override val capacityReservationSpecification
        : Option[zio.aws.ec2.model.CapacityReservationSpecification.ReadOnly] =
      scala
        .Option(impl.capacityReservationSpecification())
        .map(value =>
          zio.aws.ec2.model.CapacityReservationSpecification.wrap(value)
        )
    override val hibernationOptions
        : Option[zio.aws.ec2.model.HibernationOptionsRequest.ReadOnly] = scala
      .Option(impl.hibernationOptions())
      .map(value => zio.aws.ec2.model.HibernationOptionsRequest.wrap(value))
    override val licenseSpecifications
        : Option[List[zio.aws.ec2.model.LicenseConfigurationRequest.ReadOnly]] =
      scala
        .Option(impl.licenseSpecifications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.LicenseConfigurationRequest.wrap(item)
          }.toList
        )
    override val metadataOptions
        : Option[zio.aws.ec2.model.InstanceMetadataOptionsRequest.ReadOnly] =
      scala
        .Option(impl.metadataOptions())
        .map(value =>
          zio.aws.ec2.model.InstanceMetadataOptionsRequest.wrap(value)
        )
    override val enclaveOptions
        : Option[zio.aws.ec2.model.EnclaveOptionsRequest.ReadOnly] = scala
      .Option(impl.enclaveOptions())
      .map(value => zio.aws.ec2.model.EnclaveOptionsRequest.wrap(value))
    override val privateDnsNameOptions
        : Option[zio.aws.ec2.model.PrivateDnsNameOptionsRequest.ReadOnly] =
      scala
        .Option(impl.privateDnsNameOptions())
        .map(value =>
          zio.aws.ec2.model.PrivateDnsNameOptionsRequest.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.RunInstancesRequest
  ): zio.aws.ec2.model.RunInstancesRequest.ReadOnly = new Wrapper(impl)
}
