package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RunInstancesMonitoringEnabled(enabled: Boolean) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.RunInstancesMonitoringEnabled = {
    import RunInstancesMonitoringEnabled.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.RunInstancesMonitoringEnabled
      .builder()
      .enabled(enabled: java.lang.Boolean)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.RunInstancesMonitoringEnabled.ReadOnly =
    zio.aws.ec2.model.RunInstancesMonitoringEnabled.wrap(buildAwsValue())
}
object RunInstancesMonitoringEnabled {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.RunInstancesMonitoringEnabled
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.RunInstancesMonitoringEnabled =
      zio.aws.ec2.model.RunInstancesMonitoringEnabled(enabled)
    def enabled: Boolean
    def getEnabled: ZIO[Any, Nothing, Boolean] = ZIO.succeed(enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.RunInstancesMonitoringEnabled
  ) extends zio.aws.ec2.model.RunInstancesMonitoringEnabled.ReadOnly {
    override val enabled: Boolean = impl.enabled(): Boolean
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.RunInstancesMonitoringEnabled
  ): zio.aws.ec2.model.RunInstancesMonitoringEnabled.ReadOnly = new Wrapper(
    impl
  )
}
