package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RestoreImageFromRecycleBinResponse(
    returnValue: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.RestoreImageFromRecycleBinResponse = {
    import RestoreImageFromRecycleBinResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.RestoreImageFromRecycleBinResponse
      .builder()
      .optionallyWith(returnValue.map(value => value: java.lang.Boolean))(
        _.returnValue
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.RestoreImageFromRecycleBinResponse.ReadOnly =
    zio.aws.ec2.model.RestoreImageFromRecycleBinResponse.wrap(buildAwsValue())
}
object RestoreImageFromRecycleBinResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.RestoreImageFromRecycleBinResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.RestoreImageFromRecycleBinResponse =
      zio.aws.ec2.model
        .RestoreImageFromRecycleBinResponse(returnValue.map(value => value))
    def returnValue: Option[Boolean]
    def getReturnValue: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("returnValue", returnValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.RestoreImageFromRecycleBinResponse
  ) extends zio.aws.ec2.model.RestoreImageFromRecycleBinResponse.ReadOnly {
    override val returnValue: Option[Boolean] =
      scala.Option(impl.returnValue()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.RestoreImageFromRecycleBinResponse
  ): zio.aws.ec2.model.RestoreImageFromRecycleBinResponse.ReadOnly =
    new Wrapper(impl)
}
