package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RemoveIpamOperatingRegion(regionName: Option[String] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.RemoveIpamOperatingRegion = {
    import RemoveIpamOperatingRegion.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.RemoveIpamOperatingRegion
      .builder()
      .optionallyWith(regionName.map(value => value: java.lang.String))(
        _.regionName
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.RemoveIpamOperatingRegion.ReadOnly =
    zio.aws.ec2.model.RemoveIpamOperatingRegion.wrap(buildAwsValue())
}
object RemoveIpamOperatingRegion {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.RemoveIpamOperatingRegion
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.RemoveIpamOperatingRegion =
      zio.aws.ec2.model
        .RemoveIpamOperatingRegion(regionName.map(value => value))
    def regionName: Option[String]
    def getRegionName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("regionName", regionName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.RemoveIpamOperatingRegion
  ) extends zio.aws.ec2.model.RemoveIpamOperatingRegion.ReadOnly {
    override val regionName: Option[String] =
      scala.Option(impl.regionName()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.RemoveIpamOperatingRegion
  ): zio.aws.ec2.model.RemoveIpamOperatingRegion.ReadOnly = new Wrapper(impl)
}
