package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.VpcPeeringConnectionId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RejectVpcPeeringConnectionRequest(
    vpcPeeringConnectionId: VpcPeeringConnectionId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.RejectVpcPeeringConnectionRequest = {
    import RejectVpcPeeringConnectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.RejectVpcPeeringConnectionRequest
      .builder()
      .vpcPeeringConnectionId(
        VpcPeeringConnectionId.unwrap(vpcPeeringConnectionId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.RejectVpcPeeringConnectionRequest.ReadOnly =
    zio.aws.ec2.model.RejectVpcPeeringConnectionRequest.wrap(buildAwsValue())
}
object RejectVpcPeeringConnectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.RejectVpcPeeringConnectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.RejectVpcPeeringConnectionRequest =
      zio.aws.ec2.model
        .RejectVpcPeeringConnectionRequest(vpcPeeringConnectionId)
    def vpcPeeringConnectionId: VpcPeeringConnectionId
    def getVpcPeeringConnectionId: ZIO[Any, Nothing, VpcPeeringConnectionId] =
      ZIO.succeed(vpcPeeringConnectionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.RejectVpcPeeringConnectionRequest
  ) extends zio.aws.ec2.model.RejectVpcPeeringConnectionRequest.ReadOnly {
    override val vpcPeeringConnectionId: VpcPeeringConnectionId =
      zio.aws.ec2.model.primitives
        .VpcPeeringConnectionId(impl.vpcPeeringConnectionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.RejectVpcPeeringConnectionRequest
  ): zio.aws.ec2.model.RejectVpcPeeringConnectionRequest.ReadOnly = new Wrapper(
    impl
  )
}
